package jp.cssj.cti.servlet;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.cssj.cti.CTISession;
import jp.cssj.cti.helpers.ProgressAdapter;

/**
 * <p>
 * ̃T[ubgp邱ƂŁACSSJgServlet/JSPAvP[VȒPɍ邱Ƃł܂B
 * <p>
 * sendResourcesendMain\bh́AEFuAvP[V̎w肵pXfof[^Lv`CSSJT[o[ɑ܂B
 * eLXg̓GR[fBOServlet/JSPŎw肳GR[fBOɊւ炸UTF-8g邽߁A
 * ̃\bh̓GR[fBOw肷Kv܂B
 * </p>
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: AbstractCSSJServlet.java,v 1.3 2005/08/18 04:51:26 harumanx Exp $
 */
public abstract class AbstractCSSJServlet extends HttpServlet {
	private static final long serialVersionUID = 0L;
	
	/**
	 * CSSJT[ubg̃NGXgł邱ƂNGXg̃L[łB
	 */
	public static final String FROM_CSSJ = "jp.cssj.cti.servlet.FROM_CSSJ";

	protected void service(final HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException {
		// ڑ
		CTISession session = this.createSession(request, response);
		try {
			String type = "application/pdf";
			// Content-Typewb_o͂
			response.setContentType(type);

			// NCAgɌʂo͂
			session.setOutput(response.getOutputStream(), "application/pdf");

			// Content-Lengthwb_o͂(dv!)
			session.setProgressListener(new ProgressAdapter(true) {
				public void contentLength(long contentLength) {
					response.setContentLength((int) contentLength);
				}
			});

			this.process(session, request, response);
		} finally {
			// ZbV(Y₷̂Œ!)
			session.close();
		}
	}

	/**
	 * \[X𑗐M܂B
	 * <p>
	 * 
	 * @param session
	 *            ZbV
	 * @param request
	 *            T[ubgNGXg
	 * @param response
	 *            T[ubgX|X
	 * @param path
	 *            Servlet/JSP̃pX
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * 
	 * @throws ServletException
	 * @throws IOException
	 */
	protected void sendResource(CTISession session, HttpServletRequest request,
			HttpServletResponse response, String path, String mimeType)
			throws ServletException, IOException {
		OutputStream out = session.sendResource("resource:" + path, mimeType,
				"UTF-8");
		CSSJHttpServletResponseWrapper responseWrapper = new CSSJHttpServletResponseWrapper(
				response, out, "UTF-8");
		try {
			RequestDispatcher dispatcher = request.getRequestDispatcher(path);
			request.setAttribute(FROM_CSSJ, Boolean.TRUE);
			dispatcher.include(request, responseWrapper);
			request.removeAttribute(FROM_CSSJ);
		} finally {
			responseWrapper.close();
		}
	}

	/**
	 * {̂𑗐M܂B
	 * 
	 * @param session
	 *            ZbV
	 * @param request
	 *            T[ubgNGXg
	 * @param response
	 *            T[ubgX|X
	 * @param path
	 *            Servlet/JSP̃pX
	 * @param mimeType
	 *            MIME^(ȗꍇnull)
	 * @param encoding
	 *            LN^EGR[fBO(ȗꍇnull)
	 * 
	 * @throws ServletException
	 * @throws IOException
	 */
	protected void sendMain(CTISession session, HttpServletRequest request,
			HttpServletResponse response, String path, String mimeType)
			throws ServletException, IOException {
		OutputStream out = session.sendMain("resource:" + path, mimeType,
				"UTF-8");
		CSSJHttpServletResponseWrapper responseWrapper = new CSSJHttpServletResponseWrapper(
				response, out, "UTF-8");
		try {
			RequestDispatcher dispatcher = request.getRequestDispatcher(path);
			request.setAttribute(FROM_CSSJ, Boolean.TRUE);
			dispatcher.include(request, responseWrapper);
			request.removeAttribute(FROM_CSSJ);
		} finally {
			responseWrapper.close();
		}
	}

	/**
	 * ZbV쐬邽߂ɁÃ\bhĂB
	 * 
	 * @param request
	 * @param response
	 * @return
	 * @throws ServletException
	 * @throws IOException
	 */
	protected abstract CTISession createSession(HttpServletRequest request,
			final HttpServletResponse response) throws ServletException,
			IOException;

	/**
	 * PDF̐s߂ɁÃ\bhĂB
	 * 
	 * @param session
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	protected abstract void process(CTISession session,
			HttpServletRequest request, final HttpServletResponse response)
			throws ServletException, IOException;
}