package jp.cssj.cti.ctip.driver;

import java.io.IOException;

import jp.cssj.cti.CTIDriver;
import jp.cssj.cti.CTISession;
import jp.cssj.cti.ctip.ContentProducer;

/**
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: CTIPDriver.java,v 1.2 2005/08/18 04:51:26 harumanx Exp $
 */
public class CTIPDriver implements CTIDriver {
	private final int port;

	private final String host;

	public CTIPDriver(String host, int port) {
		this.host = host;
		this.port = port;
	}

	/**
	 * ჌x̒ʐM𐧌䂷邽߂ContentProducerCX^XԂ܂B
	 * 
	 * ȏłAAvP[VJ҂͒ʏgKv͂܂B
	 * 
	 * @return ContentProducerCX^XB
	 * @throws IOException
	 */
	public ContentProducer createContentProducer() throws IOException {
		return new ContentProducerImpl(this.host, this.port, "UTF-8");
	}

	public CTISession createSession(String user, String password)
			throws IOException {
		ContentProducerImpl producer = (ContentProducerImpl) this
				.createContentProducer();
		return new CTIPSession(producer, user, password);
	}
}