package jp.cssj.cti.helpers;

/**
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: ErrorHandler.java,v 1.2 2005/09/06 22:13:47 harumanx Exp $
 */
public abstract class ErrorHandler {
	public static final byte WARN = 1;

	public static final byte ERROR = 2;

	public static final byte FATAL = 3;

	public static final byte INFO = 4;

	public void warn(String message) {
		this.message(WARN, message);
	}

	public void error(String message) {
		this.message(ERROR, message);
	}

	public void fatal(String message) {
		this.message(FATAL, message);
	}

	public void info(String category, String message) {
		this.message(INFO, category + ":" + message);
	}

	public abstract void message(byte level, String message);
}