#!/usr/bin/perl
=head1 NAME

ファイル出力サンプル

=head2 概要

test.css,test.htmlをtest.pdfに変換します。

=cut
use strict;
use lib '../code';
use CSSJ::Driver;

open(FP, '>test.pdf');
binmode(FP);

my $driver = CSSJ::Driver::create_driver_for('localhost', 8099, 'UTF-8');
my $session = $driver->create_session('user', 'kappa');
$session->set_output(*FP);
$session->set_error_func (sub {
	print STDERR $_[0].': '.$_[1]."\n";
});

$session->set_property("output.pdf.compression", "none");

$session->start_resource(*STDOUT, 'file:/test.css');
open(RFP, '<test.css');
while (<RFP>) {print};
close(RFP);
$session->end_resource(*STDOUT);

$session->start_main(*STDOUT, 'file:/test.html');
open(MFP, '<test.html');
while (<MFP>) {print};
close(MFP);
$session->end_main(*STDOUT);

$session->close();

close(FP);

print "Location: test.pdf\n\n";
