<?php
/**
 * このサンプルを動かすには、ディレクトリに書き込み権限が必要です。
 */
require_once ('../code/cssj_driver.php');

//ドライバの作成
$driver = cssj_create_driver_for('localhost', 8099);

//セッションの開始
$session = cssj_create_session($driver, 'user', 'kappa') or die('サーバーに接続できません');

//出力先ファイル
$out = fopen('test.pdf', 'w');
cssj_set_output($session, $out);

//プロパティの設定
cssj_set_property($session, 'output.pdf.compression', 'none');

//リソースの送信
cssj_ob_start_resource($session, 'file:/test.css');
readfile('test.css');
cssj_ob_end_flush_resource();

//本体の変換
$in = fopen('test.html', 'r');
cssj_ob_start_main($session, 'file:/test.html');
for (;;) {
  $data = fread($in, 8192);
  if (strlen($data) <= 0) {
    break;
  }
  echo $data;
}
cssj_ob_end_flush_main();
fclose($in);

//セッションの終了
cssj_close($session);

//出力先ファイルを閉じる
fclose($out);

//リダイレクト
header("Location: test.pdf");
exit;
?>