<?php
require_once ('../code/cssj_driver.php');
header("Content-Type: application/pdf");

//ドライバの作成
$driver = cssj_create_driver_for('localhost', 8099);

//セッションの開始
$session = cssj_create_session($driver, 'user', 'kappa') or die('サーバーに接続できません');

//リソースの送信
cssj_ob_start_resource($session, 'file:/test.css');
readfile('test.css');
cssj_ob_end_flush_resource();

//出力結果の変換の開始
cssj_ob_start_main($session, 'file:/ob.html');
?>

<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <link rel="StyleSheet" type="text/css" href="test.css">
    <title>Hello CSSJ</title>
  </head>
  <body>
    <h2>ただいまの時刻</h2>
    <p><?php echo date("l dS of F Y h:i:s A") ?></p>
  </body>
</html>

<?php
//出力結果の変換の終了
cssj_ob_end_flush_main();

//セッションの終了
cssj_close($session);

?>