<?php
/**
 * CSSJ\u306e\u8ee2\u9001\u30d7\u30ed\u30c8\u30b3\u30eb(CTIP)\u306e\u4f4e\u30ec\u30d9\u30eb\u306e\u90e8\u5206\u3092\u6271\u3044\u307e\u3059\u3002
 * 
 * \u901a\u5e38\u3001\u30d7\u30ed\u30b0\u30e9\u30de\u304c\u3053\u306e\u30d1\u30c3\u30b1\u30fc\u30b8\u3092\u76f4\u63a5\u4f7f\u3046\u5fc5\u8981\u306f\u3042\u308a\u307e\u305b\u3093\u3002
 * 
 * @package cssj
 * @subpackage ctip
 */

/**
 * \u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3\u3067\u3059\u3002
 */
require_once ('cssj_helpers.php');

/**
 * \u30ea\u30af\u30a8\u30b9\u30c8\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7:\u30d7\u30ed\u30d1\u30c6\u30a3
 * @access public
 */
define ('CSSJ_CTIP_REQ_PROPERTY', 1);
/**
 * \u30ea\u30af\u30a8\u30b9\u30c8\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7:\u30ea\u30bd\u30fc\u30b9
 * @access public
 */
define ('CSSJ_CTIP_REQ_RESOURCE', 2);
/**
 * \u30ea\u30af\u30a8\u30b9\u30c8\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7:\u672c\u4f53
 * @access public
 */
define ('CSSJ_CTIP_REQ_MAIN', 3);
/**
 * \u30ea\u30af\u30a8\u30b9\u30c8\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7:\u30c7\u30fc\u30bf
 * @access public
 */
define ('CSSJ_CTIP_REQ_DATA', 4);
/**
 * \u30ea\u30af\u30a8\u30b9\u30c8\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7:\u7d42\u4e86
 * @access public
 */
define ('CSSJ_CTIP_REQ_END', 5);

/**
 * \u30ec\u30b9\u30dd\u30f3\u30b9\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7:\u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u8ffd\u52a0
 * @access public
 */
define ('CSSJ_CTIP_RES_ADD', 1);
/**
 * \u30ec\u30b9\u30dd\u30f3\u30b9\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7:\u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u633f\u5165
 * @access public
 */
define ('CSSJ_CTIP_RES_INSERT', 2);
/**
 * \u30ec\u30b9\u30dd\u30f3\u30b9\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7:\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8
 * @access public
 */
define ('CSSJ_CTIP_RES_ERROR', 3);
/**
 * \u30ec\u30b9\u30dd\u30f3\u30b9\u30d1\u30b1\u30c3\u30c8\u30bf\u30a4\u30d7:\u30c7\u30fc\u30bf
 * @access public
 */
define ('CSSJ_CTIP_RES_DATA', 4);

/**
 * \u30e1\u30e2\u30ea\u4e0a\u306e\u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u306e\u6700\u5927\u30b5\u30a4\u30ba\u3067\u3059\u3002
 * 
 * \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u304c\u3053\u306e\u5927\u304d\u3055\u3092\u8d85\u3048\u308b\u3068\u30c7\u30a3\u30b9\u30af\u306b\u66f8\u304d\u8fbc\u307f\u307e\u3059\u3002
 * 
 * @access private
 */
define ('CSSJ_CTIP_FRG_MEM_SIZE', 256);

/**
 * \u30e1\u30e2\u30ea\u4e0a\u306b\u7f6e\u304b\u308c\u308b\u30c7\u30fc\u30bf\u306e\u6700\u5927\u30b5\u30a4\u30ba\u3067\u3059\u3002
 * 
 * \u30e1\u30e2\u30ea\u4e0a\u306e\u30c7\u30fc\u30bf\u304c\u3053\u306e\u30b5\u30a4\u30ba\u3092\u8d85\u3048\u308b\u3068\u3001
 * CSSJ_CTIP_FRG_MEM_SIZE\u3068\u306f\u7121\u95a2\u4fc2\u306b\u30c7\u30a3\u30b9\u30af\u306b\u66f8\u304d\u8fbc\u307e\u308c\u307e\u3059\u3002
 * 
 * @access private
 */
define ('CSSJ_CTIP_ON_MEMORY', 1024 * 1024);

/**
 * \u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306e\u30bb\u30b0\u30e1\u30f3\u30c8\u30b5\u30a4\u30ba\u3067\u3059\u3002
 *
 * @access private
 */
define ('CSSJ_CTIP_SEGMENT_SIZE', 8192);

/**
 * \u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u958b\u59cb\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $encoding string \u901a\u4fe1\u306b\u7528\u3044\u308b\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 * @access public
 */
function cssj_ctip_connect(&$fp, $encoding) {
  $err = fwrite($fp, "CTIP/1.0 $encoding\n");
  return ($err === false) ? false : true; 
}

/**
 * \u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u9001\u308a\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $name string \u540d\u524d
 * @param $value string \u5024
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 * @access public
 */
function cssj_ctip_req_property(&$fp, $name, $value) {
  $payload = strlen($name) + strlen($value) + 5;
  if (cssj_utils_write_int($fp, $payload) === false) {
    return false;
  }
  if (cssj_utils_write_byte($fp, CSSJ_CTIP_REQ_PROPERTY) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $name) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $value) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * \u30ea\u30bd\u30fc\u30b9\u306e\u958b\u59cb\u3092\u901a\u77e5\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $uri string URI
 * @param $mimeType string MIME\u578b
 * @param $encoding string \u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 * @access public
 */
function cssj_ctip_req_resource(&$fp, $uri, $mimeType = 'text/css', $encoding = '') {
  $payload = strlen($uri) + strlen($mimeType) + strlen($encoding) + 5;
  if (cssj_utils_write_int($fp, $payload) === false) {
    return false;
  }
  if (cssj_utils_write_byte($fp, CSSJ_CTIP_REQ_RESOURCE) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $uri) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $mimeType) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $encoding) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * \u672c\u4f53\u306e\u958b\u59cb\u3092\u901a\u77e5\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $uri string URI
 * @param $mimeType string MIME\u578b
 * @param $encoding string \u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 * @access public
 */
function cssj_ctip_req_main(&$fp, $uri, $mimeType = 'text/html', $encoding = '') {
  $payload = strlen($uri) + strlen($mimeType) + strlen($encoding) + 5;
  if (cssj_utils_write_int($fp, $payload) === false) {
    return false;
  }
  if (cssj_utils_write_byte($fp, CSSJ_CTIP_REQ_MAIN) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $uri) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $mimeType) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $encoding) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * \u30c7\u30fc\u30bf\u3092\u9001\u308a\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $b string \u30c7\u30fc\u30bf
 * @param $len int \u30c7\u30fc\u30bf\u306e\u9577\u3055
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 * @access public
 */
function cssj_ctip_req_write(&$fp, &$b, $len = -1) {
  if ($len == -1) {
    $len = strlen($b);
  }
  else {
    $len = min(strlen($b), $len);
  }
  $payload = $len + 1;
  if (cssj_utils_write_int($fp, $payload) === false) {
    return false;
  }
  if (cssj_utils_write_byte($fp, CSSJ_CTIP_REQ_DATA) === false) {
    return false;
  }
  if (fwrite($fp, $b, $len) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * \u7d42\u4e86\u3092\u901a\u77e5\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 * @access public
 */
function cssj_ctip_req_end(&$fp) {
  if (cssj_utils_write_int($fp, 0) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * \u6b21\u306e\u30ec\u30b9\u30dd\u30f3\u30b9\u3092\u53d6\u5f97\u3057\u307e\u3059\u3002
 * 
 * \u30ec\u30b9\u30dd\u30f3\u30b9(array)\u306b\u306f\u6b21\u306e\u30c7\u30fc\u30bf\u304c\u542b\u307e\u308c\u307e\u3059\u3002
 * 
 * - 'type' \u30ec\u30b9\u30dd\u30f3\u30b9\u30bf\u30a4\u30d7
 * - 'anchorId' \u633f\u5165\u3059\u308b\u5834\u6240\u306e\u76f4\u5f8c\u306e\u30d5\u30e9\u30b0\u30e1\u30f3\u30c8ID
 * - 'level' \u30a8\u30e9\u30fc\u30ec\u30d9\u30eb
 * - 'error' \u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8
 * - 'id' \u65ad\u7247ID
 * - 'progress' \u51e6\u7406\u6e08\u30d0\u30a4\u30c8\u6570
 * - 'bytes' \u30c7\u30fc\u30bf\u306e\u30d0\u30a4\u30c8\u5217
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @return mixed \u30ec\u30b9\u30dd\u30f3\u30b9,\u30ec\u30b9\u30dd\u30f3\u30b9\u306e\u7d42\u4e86\u306a\u3089null,\u5931\u6557\u306a\u3089false
 * @access public
 */
function cssj_ctip_res_next(&$fp) {
  if (($payload = cssj_utils_read_int($fp)) === false) {
    return false;
  }
  if ($payload === 0) {
    return null;
  }
  if (($type = cssj_utils_read_byte($fp)) === false) {
    return false;
  }
  
  switch ($type) {
      case CSSJ_CTIP_RES_ADD:
      return array(
        'type' => $type,
      );
      
      case CSSJ_CTIP_RES_INSERT:
      if (($anchorId = cssj_utils_read_int($fp)) === false) {
        return false;
      }
      return array(
        'type' => $type,
        'anchorId' => $anchorId
      );
      
      case CSSJ_CTIP_RES_ERROR:
      if (($level = cssj_utils_read_byte($fp)) === false) {
        return false;
      }
      if (($error = cssj_utils_read_bytes($fp)) === false) {
        return false;
      }
      return array(
        'type' => $type,
        'level' => $level,
        'error' => $error
      );
      
      case CSSJ_CTIP_RES_DATA:
      if (($id = cssj_utils_read_int($fp)) === false) {
        return false;
      }
      if (($progress = cssj_utils_read_int($fp)) === false) {
        return false;
      }
      if (($bytes = _cssj_read($fp, $payload - 9)) === false) {
        return false;
      }
      return array(
        'type' => $type,
        'id' => $id,
        'progress' => $progress,
        'bytes' => &$bytes
      );
      
      default:
      trigger_error ("Bad response type:$type", E_USER_ERROR);
      return false;
  }
}

/**
 * \u30ec\u30b9\u30dd\u30f3\u30b9\u304b\u3089\u30c7\u30fc\u30bf\u3092\u69cb\u7bc9\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $out mixed \u51fa\u529b\u5148\u30b9\u30c8\u30ea\u30fc\u30e0(resource),\u51fa\u529b\u5148\u5909\u6570(string),\u307e\u305f\u306f\u6a19\u6e96\u51fa\u529b\u3067\u3042\u308c\u3070null\u3002
 * @param $errorFunc \u30a8\u30e9\u30fc\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570
 * @param $progressFunc \u9032\u884c\u72b6\u6cc1\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 * @access public
 */
function cssj_ctip_res_build(&$fp, &$out, &$errorFunc, &$progressFunc) {
  $builder = cssj_ctip_res_create_builder($fp, $out, $errorFunc, $progressFunc);
  while (($err = cssj_ctip_res_build_next($builder)) === true)
    ;
  return ($err === null) ? true : false;
}

/**
 * \u30d3\u30eb\u30c0\u30fc\u3092\u69cb\u7bc9\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $out mixed \u51fa\u529b\u5148\u30b9\u30c8\u30ea\u30fc\u30e0(resource),\u51fa\u529b\u5148\u5909\u6570(string),\u307e\u305f\u306f\u6a19\u6e96\u51fa\u529b\u3067\u3042\u308c\u3070null\u3002
 * @param $errorFunc \u30a8\u30e9\u30fc\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570
 * @param $progressFunc \u9032\u884c\u72b6\u6cc1\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570
 * @return mixed \u30d3\u30eb\u30c0\u30fc,\u30a8\u30e9\u30fc\u306e\u5834\u5408\u306ffalse
 * @access public
 */
function &cssj_ctip_res_create_builder(&$fp, &$out, &$errorFunc, &$progressFunc) {
  if (($tempFile = tmpfile()) === false) {
    return false;
  }
  $builder = array(
    'fp' => &$fp,
    'out' => &$out,
    'errorFunc' => &$errorFunc,
    'progressFunc' => &$progressFunc,
    'tempFile' => &$tempFile,
    'frgs' => array(),
    'first' => null,
    'last' => null,
    'onMemory' => 0,
    'length' => 0,
    'segment' => 0
  );
  return $builder;
}

/**
 * \u6b21\u306e\u30d3\u30eb\u30c9\u30bf\u30b9\u30af\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002
 * 
 * @param $builder array \u30d3\u30eb\u30c0\u30fc
 * @return mixed \u6b21\u304c\u3042\u308b\u5834\u5408\u306ftrue,\u7d42\u308f\u3063\u305f\u5834\u5408\u306fnull,\u30a8\u30e9\u30fc\u306e\u5834\u5408\u306ffalse
 */
function cssj_ctip_res_build_next(&$builder) {
  $fp =& $builder['fp'];
  $out =& $builder['out'];
  $errorFunc =& $builder['errorFunc'];
  $progressFunc =& $builder['progressFunc'];
  $tempFile =& $builder['tempFile'];
  $frgs =& $builder['frgs'];
  $first =& $builder['first'];
  $last =& $builder['last'];
  $onMemory =& $builder['onMemory'];
  $length =& $builder['length'];
  $segment =& $builder['segment'];
  
  if (($next = cssj_ctip_res_next($fp)) !== null) {
    if ($next === false) {
      fclose($tempFile);
      return false;
    }
    $type = $next['type'];
    switch ($type) {
      case CSSJ_CTIP_RES_ADD:
      $id = count($frgs);
      $frg =& _cssj_new_frg($id);
      $frgs[$id] =& $frg;
      if (is_null($first)) {
        $first =& $frg;
      }
      else {
        $last['next'] =& $frg;
        $frg['prev'] =& $last;
      }
      $last =& $frg;
      break;
      
      case CSSJ_CTIP_RES_INSERT:
      $anchorId = $next['anchorId'];
      $id = count($frgs);
      $anchor =& $frgs[$anchorId];
      $frg =& _cssj_new_frg($id);
      $frgs[$id] =& $frg;
      $frg['prev'] =& $anchor['prev'];
      $frg['next'] =& $anchor;
      $anchor['prev']['next'] =& $frg;
      $anchor['prev'] =& $frg;
      if ($first['id'] === $anchor['id']) {
        $first =& $frg;
      }
      break;
      
      case CSSJ_CTIP_RES_ERROR:
      if (isset($errorFunc)) {
        $errorFunc($next['level'], $next['error']);
      }
      break;
      
      case CSSJ_CTIP_RES_DATA:
      if (isset($progressFunc)) {
        $progressFunc($next['progress']);
      }
      $frg =& $frgs[$next['id']];
      if (($length += _cssj_write_frg($tempFile, $onMemory, $segment, $frg, $next['bytes'])) === false) {
        fclose($tempFile);
        return false;
      }
      break;
    }
    
    $builder['first'] =& $first;
    $builder['last'] =& $last;
    return true;
  }
  else {
    //\u69cb\u7bc9\u3092\u5b8c\u4e86\u3057\u3066\u30c7\u30fc\u30bf\u3092\u9001\u308a\u51fa\u3057\u307e\u3059
    if ($out === null) {
      header("Content-Length: $length");
    }
    
    $frg =& $first;
    while (!is_null($frg)) {
      if (_cssj_flush_frg($tempFile, $frg, $out) === false) {
        fclose($tempFile);
        return false;
      }
      $frg =& $frg['next'];
    }
    
    fclose($tempFile);
    return null;
  }
}

/**
 * \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002
 * 
 * @param $id int \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8ID
 * @return array \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8
 * @access private
 */
function &_cssj_new_frg($id) {
  $frg = array(
    'id' => $id,
    'prev' => null,
    'next' => null,
    'length' => 0,
    'buffer' => ''
  );
  return $frg;
}

/**
 * \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u306b\u30c7\u30fc\u30bf\u3092\u66f8\u304d\u8fbc\u307f\u307e\u3059\u3002
 * 
 * @param $tempFile resource \u4e00\u6642\u30d5\u30a1\u30a4\u30eb
 * @param $onMemory int \u30e1\u30e2\u30ea\u4e0a\u306b\u7f6e\u304b\u308c\u305f\u30c7\u30fc\u30bf\u306e\u5408\u8a08\u30b5\u30a4\u30ba
 * @param $segment int \u30bb\u30b0\u30e1\u30f3\u30c8\u756a\u53f7\u30b7\u30fc\u30b1\u30f3\u30b9
 * @param $frg array \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8
 * @param $bytes string \u30c7\u30fc\u30bf
 * @return mixed \u6210\u529f\u306a\u3089\u66f8\u304d\u8fbc\u3093\u3060\u30d0\u30a4\u30c8\u6570,\u5931\u6557\u306a\u3089false
 * @access private
 */
function _cssj_write_frg(&$tempFile, &$onMemory, &$segment, &$frg, &$bytes) {
  $len = strlen($bytes);
  if (!isset($frg['segments']) &&
           ($frg['length'] + $len) <= CSSJ_CTIP_FRG_MEM_SIZE &&
           ($onMemory + $len) <= CSSJ_CTIP_ON_MEMORY) {
    $frg['buffer'] .= $bytes;
    $onMemory += $len;
  }
  else {
    if (isset($frg['buffer'])) {
      if (($wlen = _cssj_raf_write($tempFile, $segment, $frg, $frg['buffer'])) === false) {
          return false;
      }
      $onMemory -= $wlen;
      unset($frg['buffer']);
    }
    if (($len = _cssj_raf_write($tempFile, $segment, $frg, $bytes)) === false) {
      return false;
    }
  }
  $frg['length'] += $len;
  return $len;
}

/**
 * \u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u306b\u66f8\u304d\u8fbc\u307f\u307e\u3059\u3002
 *
 * @param $tempFile resource \u4e00\u6642\u30d5\u30a1\u30a4\u30eb
 * @param $segment int \u30bb\u30b0\u30e1\u30f3\u30c8\u756a\u53f7\u30b7\u30fc\u30b1\u30f3\u30b9
 * @param $frg array \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8
 * @param $bytes string \u30c7\u30fc\u30bf
 * @return mixed \u66f8\u304d\u8fbc\u3093\u3060\u30d0\u30a4\u30c8\u6570\u3002\u5931\u6557\u3057\u305f\u5834\u5408\u306ffalse\u3002
 * @access private
 */
function _cssj_raf_write(&$tempFile, &$segment, &$frg, $bytes) {
  if (!isset($frg['segments'])) {
    $frg['segments'] = array($segment++);
    $frg['segLen'] = 0;
  }
  $segments =& $frg['segments'];
  $segLen =& $frg['segLen'];
  $written = 0;
  while (($len = strlen($bytes)) > 0) {
	if ($segLen == CSSJ_CTIP_SEGMENT_SIZE) {
		$segments[] = $segment++;
		$segLen = 0;
	}
	$seg = $segments[count($segments) - 1];
	$wlen = min($len, CSSJ_CTIP_SEGMENT_SIZE - $segLen);
	$wpos = $seg * CSSJ_CTIP_SEGMENT_SIZE + $segLen;
	if (fseek($tempFile, $wpos) === -1) {
	  return false;
	}
	if (($wlen = fwrite($tempFile, $bytes, $wlen)) === false) {
	  return false;
	}
	$segLen += $wlen;
	$written += $wlen;
	$bytes = substr($bytes, $wlen);
  }
  return $written;
}

/**
 * \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u306e\u5185\u5bb9\u3092\u5410\u304d\u51fa\u3057\u3066\u3001\u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u3092\u7834\u68c4\u3057\u307e\u3059\u3002
 * 
 * @param $tempFile resource \u4e00\u6642\u30d5\u30a1\u30a4\u30eb
 * @param $frg array \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8
 * @param $out mixed \u51fa\u529b\u5148\u30b9\u30c8\u30ea\u30fc\u30e0(resource),\u51fa\u529b\u5148\u5909\u6570(string),\u307e\u305f\u306f\u6a19\u6e96\u51fa\u529b\u3067\u3042\u308c\u3070null\u3002
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 * @access private
 */
function _cssj_flush_frg(&$tempFile, &$frg, &$out) {
  if (!isset($frg['segments'])) {
    if (_cssj_output($out, $frg['buffer']) === false) {
      return false;
    }
    unset($frg['buffer']);
  }
  else {
    $segments =& $frg['segments'];
    $segcount = count($segments);
    for ($i = 0; $i < $segcount - 1; ++$i) {
      $seg = $segments[$i];
      $rpos = $seg * CSSJ_CTIP_SEGMENT_SIZE;
      if (fseek($tempFile, $rpos) == -1) {
        return false;
      }
      if (($buff = _cssj_read($tempFile, CSSJ_CTIP_SEGMENT_SIZE)) === false) {
        return false;
      }
      if (_cssj_output($out, $buff) === false) {
        return false;
      }
    }
    $seg = $segments[$segcount - 1];
    $rpos = $seg * CSSJ_CTIP_SEGMENT_SIZE;
    if (fseek($tempFile, $rpos) == -1) {
      return false;
    }
    if (($buff = _cssj_read($tempFile, $frg['segLen'])) === false) {
      return false;
    }
    if (_cssj_output($out, $buff) === false) {
      return false;
    }
  }
  return true;
}

/**
 * \u6a19\u6e96\u51fa\u529b\u3001\u30b9\u30c8\u30ea\u30fc\u30e0\u3001\u5909\u6570\u306e\u3044\u305a\u308c\u304b\u306b\u51fa\u529b\u3057\u307e\u3059\u3002
 *
 * @param $out mixed \u51fa\u529b\u5148
 * @param $buff string \u30c7\u30fc\u30bf
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 * @access private
 */
function _cssj_output(&$out, &$buff) {
  if ($out === null) {
    //\u6a19\u6e96\u51fa\u529b
    echo $buff;
  }
  elseif (is_resource($out)) {
    //\u30b9\u30c8\u30ea\u30fc\u30e0
    if (fwrite($out, $buff) === false) {
      return false;
    }
  }
  else {
    //\u5909\u6570
    $out .= $buff;
  }
  return true;
}

?>
