<?php
/**
 * \u30b9\u30c8\u30ea\u30fc\u30e0\u3078\u30c7\u30fc\u30bf\u3092\u5165\u51fa\u529b\u3059\u308b\u305f\u3081\u306e\u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3\u3067\u3059\u3002
 * 
 * \u3053\u308c\u3089\u306e\u95a2\u6570\u306f\u3001\u30ce\u30f3\u30d6\u30ed\u30c3\u30ad\u30f3\u30b0I/O\u306b\u5bfe\u3057\u3066\u3082\u4e0e\u3048\u3089\u308c\u305f(\u8981\u6c42\u3055\u308c\u308b)\u30c7\u30fc\u30bf\u3092\u5168\u3066\u51fa\u529b(\u5165\u529b)\u3057\u307e\u3059\u3002
 * 
 * \u901a\u5e38\u3001\u30d7\u30ed\u30b0\u30e9\u30de\u304c\u3053\u306e\u30d1\u30c3\u30b1\u30fc\u30b8\u3092\u76f4\u63a5\u4f7f\u3046\u5fc5\u8981\u306f\u3042\u308a\u307e\u305b\u3093\u3002
 * 
 * @package cssj
 * @subpackage helpers
 */
/**
 * \u30d1\u30b1\u30c3\u30c8\u306e\u9001\u4fe1\u306b\u4f7f\u3046\u30d0\u30c3\u30d5\u30a1\u306e\u30b5\u30a4\u30ba\u3067\u3059\u3002
 * 
 * @access private
 */
define ('CSSJ_BUFFER_SIZE', 1024);

/**
 * 32\u30d3\u30c3\u30c8\u6570\u5024\u3092\u30d3\u30c3\u30b0\u30a4\u30f3\u30c7\u30a3\u30a2\u30f3\u3067\u66f8\u304d\u51fa\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $a int \u6570\u5024
 * @return mixed \u66f8\u304d\u8fbc\u3093\u3060\u30d0\u30a4\u30c8\u6570\u3001\u30a8\u30e9\u30fc\u3067\u3042\u308c\u3070false
 * @access public
 */
function cssj_utils_write_int(&$fp, $a) {
  $data = pack('N', $a);
  return _cssj_write($fp, $data);
}

/**
 * 8\u30d3\u30c3\u30c8\u6570\u5024\u3092\u66f8\u304d\u51fa\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $a byte \u6570\u5024
 * @return mixed \u66f8\u304d\u8fbc\u3093\u3060\u30d0\u30a4\u30c8\u6570\u3001\u30a8\u30e9\u30fc\u3067\u3042\u308c\u3070false
 * @access public
 */
function cssj_utils_write_byte(&$fp, $b) {
  $data = chr($b);
  return _cssj_write($fp, $data);
}

/**
 * \u30d0\u30a4\u30c8\u6570\u309216\u30d3\u30c3\u30c8\u30d3\u30c3\u30b0\u30a4\u30f3\u30c7\u30a3\u30a2\u30f3\u3067\u66f8\u304d\u51fa\u3057\u305f\u5f8c\u3001\u30d0\u30a4\u30c8\u5217\u3092\u66f8\u304d\u51fa\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $b string \u30d0\u30a4\u30c8\u5217
 * @return mixed \u66f8\u304d\u8fbc\u3093\u3060\u30d0\u30a4\u30c8\u6570\u3001\u30a8\u30e9\u30fc\u3067\u3042\u308c\u3070false
 * @access public
 */
function cssj_utils_write_bytes(&$fp, &$b) {
  $data = pack('n', strlen($b));
  $len = _cssj_write($fp, $data);
  if ($len === false) {
    return $len;
  }
  return _cssj_write($fp, $b);
}

/**
 * \u30d0\u30a4\u30c8\u5217\u3092\u66f8\u304d\u51fa\u3057\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $data string \u30d0\u30a4\u30c8\u5217
 * @return mixed \u66f8\u304d\u8fbc\u3093\u3060\u30d0\u30a4\u30c8\u6570\u3001\u30a8\u30e9\u30fc\u3067\u3042\u308c\u3070false
 * @access private
 */
function _cssj_write(&$fp, &$data) {
  for (;;) {
    $len = fwrite($fp, $data);
    if ($len === false || $len >= strlen($data)) {
      return $len;
    }
    $data = substr($data, $len, strlen($data) - $len);
  }
}

/**
 * 32\u30d3\u30c3\u30c8\u30d3\u30c3\u30b0\u30a4\u30f3\u30c7\u30a3\u30a2\u30f3\u6570\u5024\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @return mixed \u6570\u5024\u3001\u30a8\u30e9\u30fc\u3067\u3042\u308c\u3070false
 * @access public
 */
function cssj_utils_read_int(&$fp) {
  $b = _cssj_read($fp, 4);
  if ($b === false) {
    return $b;
  }
  $a = unpack('Nint', $b);
  return $a['int'];
}

/**
 * 8\u30d3\u30c3\u30c8\u6570\u5024\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @return mixed \u6570\u5024\u3001\u30a8\u30e9\u30fc\u3067\u3042\u308c\u3070false
 * @access public
 */
function cssj_utils_read_byte(&$fp) {
  $b = _cssj_read($fp, 1);
  if ($b === false) {
    return $b;
  }
  return ord($b);
}

/**
 * 16\u30d3\u30c3\u30c8\u30d3\u30c3\u30b0\u30a4\u30f3\u30c7\u30a3\u30a2\u30f3\u6570\u5024\u3092\u8aad\u307f\u8fbc\u307f\u3001\u305d\u306e\u30d0\u30a4\u30c8\u6570\u3060\u3051\u30d0\u30a4\u30c8\u5217\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @return mixed \u30d0\u30a4\u30c8\u5217\u3001\u30a8\u30e9\u30fc\u3067\u3042\u308c\u3070false
 * @access public
 */
function &cssj_utils_read_bytes(&$fp) {
  $b = _cssj_read($fp, 2);
  if ($b === false) {
    return $b;
  }
  $a = unpack('nshort', $b);
  $len = $a['short'];
  $b = _cssj_read($fp, $len);
  if ($b === false) {
    return $b;
  }
  return $b;
}

/**
 * \u30d0\u30a4\u30c8\u5217\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002
 * 
 * @param $fp resource \u30b9\u30c8\u30ea\u30fc\u30e0
 * @param $len int \u8981\u6c42\u3055\u308c\u308b\u30d0\u30a4\u30c8\u6570
 * @return mixed \u30d0\u30a4\u30c8\u5217\u3001\u30a8\u30e9\u30fc\u3067\u3042\u308c\u3070false
 * @access private
 */
function &_cssj_read(&$fp, $len) {
  $result = '';
  for (;;) {
  if ($len <= 0) {
      return $result;
    }
    $data = fread($fp, $len);
    if ($data === '' || $data === fase) {
      return false;
    }
    $len -= strlen($data);
    $result .= $data;
  }
}

?>
