/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.common;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public final class TcpUtils {
    private TcpUtils() {
    }

    public static byte readByte(SocketChannel channel, ByteBuffer destByte) throws IOException {
        TcpUtils.readAll(channel, destByte);
        return destByte.get(0);
    }

    public static short readShort(SocketChannel channel, ByteBuffer destShort) throws IOException {
        TcpUtils.readAll(channel, destShort);
        return destShort.getShort(0);
    }

    public static int readInt(SocketChannel channel, ByteBuffer destInt) throws IOException {
        TcpUtils.readAll(channel, destInt);
        return destInt.getInt(0);
    }

    public static long readLong(SocketChannel channel, ByteBuffer destLong) throws IOException {
        TcpUtils.readAll(channel, destLong);
        return destLong.getLong(0);
    }

    public static String readString(SocketChannel channel, ByteBuffer destShort, String encoding) throws IOException {
        short len = TcpUtils.readShort(channel, destShort);
        if (len == 0) {
            return "";
        }
        byte[] buff = TcpUtils.readBytes(channel, len);
        return new String(buff, encoding);
    }

    public static byte[] readBytes(SocketChannel channel, int len) throws IOException {
        byte[] buff = new byte[len];
        ByteBuffer dest = ByteBuffer.wrap(buff);
        TcpUtils.readAll(channel, dest);
        return buff;
    }

    public static void readAll(SocketChannel channel, ByteBuffer dest) throws IOException {
        dest.position(0);
        do {
            if (channel.read(dest) != -1) continue;
            throw new EOFException();
        } while (dest.remaining() > 0);
    }

    public static void writeAll(SocketChannel channel, ByteBuffer src) throws IOException {
        src.position(0);
        do {
            channel.write(src);
        } while (src.remaining() > 0);
    }

    public static byte[] toBytes(String str, String encoding) throws IOException {
        if (str == null) {
            str = "";
        }
        return str.getBytes(encoding);
    }
}

