/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.StringTokenizer;
import jp.cssj.resolver.SourceValidity;
import jp.cssj.resolver.helpers.AbstractSource;
import jp.cssj.resolver.helpers.ValidSourceValidity;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.URLCodec;

public class DataSource
extends AbstractSource {
    private String mimeType = null;
    private byte[] data = null;
    private String encoding = null;
    private boolean parsed = false;

    public DataSource(URI uri) {
        super(uri);
    }

    private void parse() throws IOException {
        block12: {
            if (!this.parsed) {
                this.parsed = true;
                try {
                    String spec = this.uri.getRawSchemeSpecificPart();
                    int comma = spec.indexOf(44);
                    if (comma != -1) {
                        String type = spec.substring(0, comma);
                        String data = spec.substring(comma + 1);
                        boolean base64 = false;
                        StringTokenizer st = new StringTokenizer(type, ";");
                        while (st.hasMoreElements()) {
                            int equal;
                            String token = st.nextToken();
                            if (this.mimeType == null) {
                                if (token.indexOf(47) != -1) {
                                    this.mimeType = token;
                                    continue;
                                }
                                this.mimeType = "text/plain";
                                this.encoding = "US-ASCII";
                            }
                            if ((equal = token.indexOf(61)) != -1) {
                                String name = token.substring(0, equal);
                                if (!name.equalsIgnoreCase("charset")) continue;
                                this.encoding = token.substring(equal + 1);
                                continue;
                            }
                            if (!token.equalsIgnoreCase("base64")) continue;
                            base64 = true;
                        }
                        if (base64) {
                            byte[] bytes;
                            if (data.indexOf(37) != -1) {
                                data = data.replaceAll("\\+", "%2B");
                                bytes = data.getBytes("iso-8859-1");
                                bytes = URLCodec.decodeUrl(bytes);
                            } else {
                                bytes = data.getBytes("iso-8859-1");
                            }
                            this.data = Base64.decodeBase64(bytes);
                        } else {
                            this.data = URLCodec.decodeUrl(data.getBytes("iso-8859-1"));
                        }
                        break block12;
                    }
                    throw new IOException("data:\u30b9\u30ad\u30fc\u30de\u306e\u30c7\u30fc\u30bf\u304c\u3042\u308a\u307e\u305b\u3093");
                }
                catch (DecoderException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        }
    }

    public String getMimeType() throws IOException {
        this.parse();
        return this.mimeType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean exists() throws IOException {
        this.parse();
        return this.data != null;
    }

    public boolean isFile() throws IOException {
        return false;
    }

    public boolean isInputStream() throws IOException {
        return true;
    }

    public boolean isReader() throws IOException {
        this.parse();
        return this.encoding != null;
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.parse();
        return new ByteArrayInputStream(this.data);
    }

    public Reader getReader() throws IOException {
        if (!this.isReader()) {
            throw new UnsupportedOperationException();
        }
        return new InputStreamReader(this.getInputStream(), this.encoding);
    }

    public File getFile() {
        throw new UnsupportedOperationException();
    }

    public long getLength() throws IOException {
        this.parse();
        return this.data.length;
    }

    public SourceValidity getValidity() throws IOException {
        return ValidSourceValidity.SHARED_INSTANCE;
    }
}

