/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import jp.cssj.resolver.SourceValidity;
import jp.cssj.resolver.helpers.AbstractSource;
import jp.cssj.resolver.http.HttpSourceValidity;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;

public class HttpSource
extends AbstractSource {
    private final HttpClient httpClient;
    private String mimeType;
    private String encoding;
    private HttpMethodBase method;
    private InputStream in;
    private boolean exists;
    private long lastModified = -1L;
    private long contentLength = -1L;

    public HttpSource(URI uri, HttpClient httpClient) {
        super(uri);
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getMimeType() throws IOException {
        this.tryConnect();
        return this.mimeType;
    }

    public String getEncoding() throws IOException {
        this.tryConnect();
        return this.encoding;
    }

    public boolean exists() throws IOException {
        this.tryConnect();
        return this.exists;
    }

    public boolean isInputStream() throws IOException {
        return true;
    }

    public boolean isReader() throws IOException {
        this.tryConnect();
        return this.encoding != null;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.in != null) {
            this.method = null;
            this.in = null;
        }
        this.tryConnect();
        this.in = this.method.getResponseBodyAsStream();
        if (this.in == null) {
            throw new FileNotFoundException();
        }
        final HttpMethodBase method = this.method;
        return new FilterInputStream(this.in){

            public void close() throws IOException {
                super.close();
                method.releaseConnection();
            }
        };
    }

    protected void tryConnect() throws IOException {
        Header contentLength;
        Header lastModified;
        int status;
        if (this.method != null) {
            return;
        }
        this.method = this.createHttpMethod();
        try {
            status = this.httpClient.executeMethod(this.method);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        this.exists = status != 404;
        this.encoding = this.method.getResponseCharSet();
        try {
            if (this.encoding.equalsIgnoreCase("ISO-8859-1") || !Charset.isSupported(this.encoding)) {
                this.encoding = null;
            }
        }
        catch (Exception e) {
            this.encoding = null;
        }
        Header mimeType = this.method.getResponseHeader("Content-Type");
        if (mimeType != null) {
            this.mimeType = mimeType.getValue();
        }
        if ((lastModified = this.method.getResponseHeader("Last-Modified")) != null) {
            try {
                this.lastModified = DateUtil.parseDate(lastModified.getValue()).getTime();
            }
            catch (DateParseException e) {
                // empty catch block
            }
        }
        if ((contentLength = this.method.getResponseHeader("Content-Length")) != null) {
            try {
                this.contentLength = Long.parseLong(contentLength.getValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    protected HttpMethodBase createHttpMethod() {
        GetMethod method = new GetMethod(this.uri.toASCIIString());
        return method;
    }

    public Reader getReader() throws IOException {
        if (this.encoding == null) {
            throw new UnsupportedOperationException();
        }
        return new InputStreamReader(this.getInputStream(), this.encoding);
    }

    public File getFile() {
        throw new UnsupportedOperationException();
    }

    public long getLength() throws IOException {
        this.tryConnect();
        return this.contentLength;
    }

    public SourceValidity getValidity() {
        return new HttpSourceValidity(this.lastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.method != null) {
            try {
                this.method.releaseConnection();
                Object var2_1 = null;
                this.method = null;
                this.in = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.method = null;
                this.in = null;
                throw throwable;
            }
        }
    }
}

