package jp.cssj.cti2.examples;

import java.io.File;
import java.net.URI;

import jp.cssj.cti2.CTIDriverManager;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.CTIMessageHelper;
import jp.cssj.cti2.helpers.CTISessionHelper;
import jp.cssj.resolver.url.URLSourceResolver;

/**
 * クライアントから送ったデータを変換します。
 */
public class ClientResource {
	/** 接続先。 */
	private static final URI SERVER_URI = URI.create("ctip://127.0.0.1:8099/");

	/** ユーザー。 */
	private static final String USER = "user";

	/** パスワード。 */
	private static final String PASSWORD = "kappa";

	public static void main(String[] args) throws Exception {
		// 接続する
		CTISession session = CTIDriverManager.getSession(SERVER_URI, USER,
				PASSWORD);
		try {
			// test.pdfに結果を出力する
			{
				File file = new File("test.pdf");
				CTISessionHelper.setResultFile(session, file);
			}

			// エラーメッセージを標準出力に表示する
			session.setMessageHandler(CTIMessageHelper.createStreamMessageHandler(System.err));
			// クライアント側での解決
			session.setSourceResolver(new URLSourceResolver());

			session.property("output.pdf.version", "1.7");
			session.property("output.pdf.encryption", "v2");
			session.property("output.pdf.encryption.user-password", "test1");
			session
					.property("output.pdf.encryption.permissions.print",
							"false");
			session.property("output.pdf.encryption.permissions.modify",
					"false");
			session.property("output.pdf.encryption.permissions.copy", "false");
			session.property("output.pdf.encryption.permissions.add", "false");
			session.property("output.pdf.encryption.permissions.fill", "false");
			session.property("output.pdf.hyperlinks", "true");
			session.property("output.pdf.bookmarks", "true");
			session.property("output.meta.0.name", "DESCRIPTION");
			session.property("output.meta.0.value", "Copper PDF のサンプル");

			// 添付ファイル
			File file = new File("examples/files/test.jpeg");
			session.property("output.pdf.attachments.0.uri", file.toURI()
					.toASCIIString());
			session.property("output.pdf.attachments.0.name", "beatle.jpeg");
			session.property("output.pdf.attachments.0.description", "カブトムシ");
			CTISessionHelper
					.sendResourceFile(session, file, "image/jpeg", null);

			// HTMLファイルを送る
			// MIME型はtext/html,キャラクタ・エンコーディングは省略
			File mainFile = new File("examples/files/test.html");
			CTISessionHelper
					.transcodeFile(session, mainFile, "text/html", null);
		} finally {
			// セッションを閉じる(忘れやすいので注意!)
			session.close();
		}
	}
}