/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.cssj.cti2.CTIDriverManager;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.CTIMessageHelper;
import jp.cssj.cti2.results.SingleResult;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.composite.CompositeSourceResolver;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class TranscodeTask
extends MatchingTask {
    private SourceResolver resolver = CompositeSourceResolver.createGenericCompositeSourceResolver();
    private Connection conn = new Connection();
    private List props = new ArrayList();
    private File srcDir;
    private File destDir;
    private String suffix = ".pdf";
    private FileNameMapper myMapper = new IdentityMapper(){

        public String[] mapFileName(String src) {
            return new String[]{TranscodeTask.this.map(src)};
        }
    };

    public Connection createConnection() {
        this.conn = new Connection();
        return this.conn;
    }

    public Property createProperty() {
        Property prop = new Property();
        this.props.add(prop);
        return prop;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    private String map(String src) {
        int dot = src.lastIndexOf(46);
        String dest = dot != -1 ? src.substring(0, dot) + this.suffix : src + this.suffix;
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File srcDir = this.srcDir == null ? this.getProject().resolveFile(".") : this.srcDir;
        File destDir = this.destDir == null ? srcDir : this.destDir;
        int count = 0;
        try {
            CTISession session = CTIDriverManager.getSession(this.conn.getUri(), this.conn.getProps());
            try {
                session.setMessageHandler(CTIMessageHelper.createStreamMessageHandler(System.err));
                session.setSourceResolver(this.resolver);
                for (int i = 0; i < this.props.size(); ++i) {
                    Property prop = (Property)this.props.get(i);
                    session.property(prop.name, prop.value);
                }
                DirectoryScanner ds = this.getDirectoryScanner(srcDir);
                String[] files = ds.getIncludedFiles();
                SourceFileScanner sfs = new SourceFileScanner((Task)this);
                files = sfs.restrict(files, srcDir, this.destDir, this.myMapper);
                for (int i = 0; i < files.length; ++i) {
                    String src = files[i];
                    String dest = this.map(src);
                    File srcFile = new File(srcDir, src);
                    File destFile = new File(destDir, dest);
                    if (destFile.exists() && destFile.lastModified() >= srcFile.lastModified()) {
                        return;
                    }
                    System.out.println(srcFile.getName() + " -> " + destFile.getName());
                    destFile.getParentFile().mkdirs();
                    boolean failure = true;
                    FileOutputStream out = new FileOutputStream(destFile);
                    try {
                        session.setResults(new SingleResult(out));
                        Source source = this.resolver.resolve(srcFile.toURI());
                        try {
                            session.transcode(source);
                            failure = false;
                        }
                        finally {
                            this.resolver.release(source);
                        }
                    }
                    finally {
                        if (failure) {
                            destFile.delete();
                        }
                    }
                    ++count;
                }
            }
            finally {
                session.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new BuildException(e);
        }
        finally {
            System.out.println("Transcoded " + count + " file(s).");
        }
    }

    public class Property {
        public String name;
        public String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class Connection {
        private URI uri = URI.create("copper:direct:");
        private Map props = new HashMap();

        public void setUri(String uri) {
            this.uri = URI.create(uri);
        }

        public void setUser(String user) {
            this.props.put("user", user);
        }

        public void setPassword(String password) {
            this.props.put("password", password);
        }

        public URI getUri() {
            return this.uri;
        }

        public Map getProps() {
            return this.props.isEmpty() ? null : this.props;
        }
    }
}

