/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import jp.cssj.cti2.CTIDriver;
import jp.cssj.cti2.CTISession;
import jp.cssj.driver.ctip.v1.V1Session;
import jp.cssj.driver.ctip.v2.V2Session;
import jp.cssj.plugin.Plugin;

public class CTIPDriver
implements CTIDriver,
Plugin<URI> {
    public static final String ENCODING = "UTF-8";

    @Override
    public boolean match(URI uri) {
        if (uri == null) {
            return false;
        }
        return !uri.isOpaque() && ("ctip".equals(uri.getScheme()) || "ctips".equals(uri.getScheme()));
    }

    @Override
    public CTISession getSession(URI uri, Map<String, String> props) throws IOException {
        String query = uri.getQuery();
        String user = null;
        String password = null;
        if (props != null) {
            user = props.get("user");
            password = props.get("password");
        }
        if (query != null) {
            String[] params = query.split("&");
            for (int i = 0; i < params.length; ++i) {
                if (!params[0].equals("version=1")) continue;
                return new V1Session(uri, ENCODING, user, password);
            }
        }
        return new V2Session(uri, ENCODING, user, password);
    }
}

