/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.restricted;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.restricted.WildcardHelper;

public class RestrictedSourceResolver
implements SourceResolver {
    private SourceResolver enclosedSourceResolver;
    private final List<Pattern> acl = new ArrayList<Pattern>();

    public RestrictedSourceResolver(SourceResolver enclosedSourceResolver) {
        this.enclosedSourceResolver = enclosedSourceResolver;
    }

    public RestrictedSourceResolver() {
        this(null);
    }

    private static char convertHexDigit(char b) {
        if (b >= '0' && b <= '9') {
            return (char)(b - 48);
        }
        if (b >= 'a' && b <= 'f') {
            return (char)(b - 97 + 10);
        }
        if (b >= 'A' && b <= 'F') {
            return (char)(b - 65 + 10);
        }
        return '\u0000';
    }

    public static String toKey(URI uri) {
        String key = uri.toString();
        String scheme = uri.getScheme();
        if (scheme != null && (scheme.equals("http") || scheme.equals("https"))) {
            String exclude = "*?#";
            char[] ch = key.toCharArray();
            int len = ch.length;
            int ix = 0;
            int ox = 0;
            while (ix < len) {
                int b;
                if ((b = ch[ix++]) == 63) {
                    exclude = "*&=#";
                } else if (b == 43) {
                    b = 32;
                } else if (b == 37) {
                    char c = (char)((RestrictedSourceResolver.convertHexDigit(ch[ix]) << 4) + RestrictedSourceResolver.convertHexDigit(ch[ix + 1]));
                    if (exclude.indexOf(c) == -1) {
                        b = c;
                        ix += 2;
                    } else {
                        ch[ix] = Character.toUpperCase(ch[ix]);
                        ch[ix + 1] = Character.toUpperCase(ch[ix + 1]);
                    }
                }
                ch[ox++] = b;
            }
            key = new String(ch, 0, ox);
        }
        return key;
    }

    public void include(URI uriPattern) {
        String key = RestrictedSourceResolver.toKey(uriPattern.normalize());
        this.acl.add(new Pattern(true, WildcardHelper.compilePattern(key)));
    }

    public void exclude(URI uriPattern) {
        String key = RestrictedSourceResolver.toKey(uriPattern.normalize());
        this.acl.add(new Pattern(false, WildcardHelper.compilePattern(key)));
    }

    @Override
    public Source resolve(URI uri) throws IOException, SecurityException {
        return this.resolve(uri, false);
    }

    public Source resolve(URI uri, boolean force) throws IOException, SecurityException {
        uri = uri.normalize();
        String key = RestrictedSourceResolver.toKey(uri);
        key = key.replaceAll("\\*", "%2A");
        if (force) {
            if (this.enclosedSourceResolver == null) {
                throw new FileNotFoundException(key);
            }
            return this.enclosedSourceResolver.resolve(uri);
        }
        for (int i = 0; i < this.acl.size(); ++i) {
            Pattern pattern = this.acl.get(i);
            if (!WildcardHelper.match(key, pattern.pattern)) continue;
            if (pattern.permit) {
                if (this.enclosedSourceResolver == null) {
                    throw new FileNotFoundException(key);
                }
                return this.enclosedSourceResolver.resolve(uri);
            }
            throw new SecurityException(key);
        }
        if ("data".equals(uri.getScheme())) {
            return this.enclosedSourceResolver.resolve(uri);
        }
        throw new SecurityException(key);
    }

    @Override
    public void release(Source source) {
        assert (this.enclosedSourceResolver != null);
        this.enclosedSourceResolver.release(source);
    }

    public SourceResolver getEnclosedSourceResolver() {
        return this.enclosedSourceResolver;
    }

    public void setEnclosedSourceResolver(SourceResolver enclosedSourceResolver) {
        this.enclosedSourceResolver = enclosedSourceResolver;
    }

    public void reset() {
        this.enclosedSourceResolver = null;
        this.acl.clear();
    }

    protected static class Pattern {
        public final boolean permit;
        public final int[] pattern;

        public Pattern(boolean permit, int[] pattern) {
            this.permit = permit;
            this.pattern = pattern;
        }
    }
}

