Require Export String.
Require Export List.
Require Export ExtractUtil.

Open Scope string_scope.

Notation "op ; x" := (semicolon_flipped x op) (at level 50).

Definition mlchar_of_ascii a :=
  mlchar_of_mlint (mlint_of_nat (Ascii.nat_of_ascii a)).
Definition mlstring_of_string s :=
  mlstring_of_list mlchar_of_ascii (list_of_string s).
Definition ascii_of_mlchar c :=
  Ascii.ascii_of_nat (nat_of_mlint (mlint_of_mlchar c)).
Definition string_of_mlstring s :=
  string_of_list (list_of_mlstring ascii_of_mlchar s).

Definition print s := print_mlstring (mlstring_of_string s).
Definition println s := println_mlstring (mlstring_of_string s).

Definition string_of_nat (n:nat) :=
  string_of_mlstring (mlstring_of_mlint (mlint_of_nat n)).

Definition id {A:Type} (x:A) := x.

Definition atat {A B:Type} (f:A -> B) (x: A) := f x.
Infix "@@" := atat (at level 75).

Definition doll {A B C:Type} (g:B->C) (f:A->B) (x:A) := g (f x).
Infix "$" := doll (at level 75).
