Require Import ExtractUtil.
Require Import Util.
Require Import String.
Require Import Ascii.
Require Import List.
Open Scope string_scope.

Infix ":::" := String (at level 60, right associativity).
 
Definition string_of_nat (n:nat) :=
  string_of_mlstring (mlstring_of_mlint (mlint_of_nat n)).
 
Fixpoint format (A:Type) (f:string) : Type :=
  match f with
  | "%":::"s":::f' => string -> format A  f'
  | "%":::"d":::f' => nat -> format A  f'
  | "%":::"%":::f' => format A  f'
  | _:::f' => format A  f'
  | EmptyString => A
  end.


Lemma format_01 : forall {A:Type} (c:ascii) f',
  c <> "%"%char -> format A (c ::: f') = format A f'.
Proof.
intros A c f'; case c.
intros b1 b2 b3 b4 b5 b6 b7 b8.
case b1; case b2; case b3; case b4; case b5; case b6; case b7; case b8;
 try reflexivity.
intro H; elim H; reflexivity.
Qed.

Lemma format_02 : forall {A:Type} (c:ascii) f',
  c <> "s"%char -> c <> "d"%char -> c <> "%"%char -> format A ("%" ::: c ::: f') = format A (c:::f').
Proof.
intros A c f'.
case c.
intros b1 b2 b3 b4 b5 b6 b7 b8.
case b1; case b2; case b3; case b4; case b5; case b6; case b7; case b8;
 try reflexivity.
 intro H; elim H; reflexivity.
 
 intros _ _ H; elim H; reflexivity.
 
 intros _ H; elim H; reflexivity.
 
Qed.

Definition fprintf_aux {A:Type} (F:string -> A) (f:string) (ps:string) : format A f.
intros A F.
refine (fix iter (f : string) : string -> format A f := fun ps => _).
case_eq f.
 intro feq; exact (F ps).
 
 intros c f' feq; case (ascii_dec c "%").
  intros eq; rewrite eq in |- *.
  case_eq f'.
   intro feq0.
pose (iter_f' := iter f').
rewrite feq0 in iter_f'.
   exact (iter_f' (ps ++ c ::: f')).
   
   intros c0 f'' feq0; case (ascii_dec c0 "s").
    intros eq0; rewrite eq0 in |- *.
    exact (fun s => iter f'' (ps ++ s)).
    
    intros neq_s; case (ascii_dec c0 "d").
     intro eq0; rewrite eq0 in |- *.
     exact (fun d => iter f'' (ps ++ string_of_nat d)).
     
     intros neq_d; case (ascii_dec c0 "%").
      intro eq0; rewrite eq0 in |- *.
      exact (iter f'' (ps ++ "%")).
      
      intro neq_per.
      rewrite (format_02 c0 f'' neq_s neq_d neq_per) in |- *.
      rewrite <- feq0;
      exact (iter f' (ps ++ c ::: "")).
      
  intros neq_per.
  rewrite (format_01 _ _ neq_per) in |- *.
  exact (iter f' (ps ++ c ::: "")).
  
Defined.

Definition fprintf {A:Type} (F:string->A) s := fprintf_aux F s "".
Definition sprintf s := fprintf id s.
Definition printf s := fprintf print s.
Definition printfln s := fprintf println s.
