///////////////////////////////////////////////////////////////
//    Crowbar（クロウバー）
///////////////////////////////////////////////////////////////

// 動作に関わるオプション．ドキュメントを読んで理解したら自由に設定して構いません．
void Options() {
  // 以下はオプションの一例（crowbarClassのコメントを参照）
  // crowbar.disableDisplay();            // グラフィックスエリアに文字表示しない
  // crowbar.disableTextArea();           // 画面下のテキストエリアに文字表示しない
  // crowbar.noShowParameters();          // パラメータ入力後にパラメータの値確認なし
  // crowbar.enableLogOutput();           // default.txtにログを記録する
  // crowbar.setcolor(#ffffff, #000000);  // 白黒反転
  // crowbar.setFontSize(24);             // デカ文字

  // Main()終了後にuserDraw()を繰り返し実行するならば以下のcrowbar.nonStop()を有効にする
  crowbar.nonStop();
}

// パラメータ入力前に行っておきたい処理（setup()の最初に自動実行）
void initializeMain() {
  // 以下の行は削除してはいけない．二つの引数の値を変更するとウィンドウサイズが変わる
  crowbar = new crowbarClass(60, 40);

  ELROS = new TELROS();
}

///////////////////////////////////////////////////////////////////////////////////
// ここから下のコードはユーザが積極的に記述して構わない
///////////////////////////////////////////////////////////////////////////////////
// システム初期設定
void Setup()
{
  // プログラムコメント（パラメータ入力前に一度だけ画面表示されます．複数宣言可，省略可）
  crowbar.programComment("平面三リンクロボットシミュレータ");
  crowbar.programComment("ELROS");

  // 以下に，入力が必要なパラメータを宣言
  // crowbar.define("説明"); 複数個を宣言しても構わない．宣言が無くても構わない．
/*
  crowbar.defineSel("リンク数", "2 3", 1);
  crowbar.defineNum("リンク１の長さ", 1.0);
  crowbar.defineNum("リンク２の長さ", 1.0);
  crowbar.defineNum("リンク３の長さ", 1.0);
  crowbar.defineNum("リンク１の幅", 0.1);
  crowbar.defineNum("リンク２の幅", 0.1);
  crowbar.defineNum("リンク３の幅", 0.1);
  crowbar.defineNum("ピクセル比（pixel/m)", 200);
  crowbar.defineNum("許容位置誤差[m]", 0.001); // 1[mm]
*/
  crowbar.define("リンクの長さ", 1.0);
  crowbar.define("リンクの幅", 0.1);
}

// メインルーチン
// ユーザのメインのプログラム（１度しか実行されない）を以下に記述
// void Main() の関数名を変えてはいけない．
void Main() {
  // 変数の代入
/*
  ELROS.Robot.RobotConfig.LinkNumber = crowbar.getInt();
  ELROS.Robot.RobotConfig.L1_Length  = crowbar.getFloat();
  ELROS.Robot.RobotConfig.L2_Length  = crowbar.getFloat();
  ELROS.Robot.RobotConfig.L3_Length  = crowbar.getFloat();
  ELROS.Robot.RobotConfig.L1_Width   = crowbar.getFloat();
  ELROS.Robot.RobotConfig.L2_Width   = crowbar.getFloat();
  ELROS.Robot.RobotConfig.L3_Width   = crowbar.getFloat();
  ELROS.World.PixelRatio             = crowbar.getFloat();
  ELROS.Robot.RC.allowableError      = crowbar.getFloat();
*/
  ELROS.Robot.RobotConfig.L1_Length  = crowbar.getFloat();
  ELROS.Robot.RobotConfig.L1_Width   = crowbar.getFloat();

  // 自動計算
  ELROS.Robot.RobotConfig.LinkNumber = 3;  // 後日２リンクにも拡張予定
  ELROS.Robot.RobotConfig.L2_Length  = ELROS.Robot.RobotConfig.L1_Length;
  ELROS.Robot.RobotConfig.L3_Length  = ELROS.Robot.RobotConfig.L1_Length;
  ELROS.Robot.RobotConfig.L2_Width   = ELROS.Robot.RobotConfig.L1_Width;
  ELROS.Robot.RobotConfig.L3_Width   = ELROS.Robot.RobotConfig.L1_Width;
  ELROS.World.PixelRatio             = 200.0;
  ELROS.Robot.RC.allowableError      = 0.001;
  ELROS.Robot.RobotConfig.J1_Radius  = ELROS.Robot.RobotConfig.L1_Width;
  ELROS.Robot.RobotConfig.J2_Radius  = ELROS.Robot.RobotConfig.L2_Width;
  ELROS.Robot.RobotConfig.J3_Radius  = ELROS.Robot.RobotConfig.L3_Width;
}

// グローバル変数（ユーザ）を以下に記述
TELROS ELROS;

