
// 二次元ベクトル
class D2T {
  float  x, y;
  // コンストラクタ
  D2T() {
    x = y = 0.0;
  }
  // 減算
  D2T Sub(D2T A) {
    D2T C;
    C = new D2T();
    C.x = x - A.x;
    C.y = y - A.y;
    return C;
  }
// 加算
  D2T Add(D2T A) {
    D2T C;
    C = new D2T();
    C.x = x + A.x;
    C.y = y + A.y;
    return C;
  }
  // ノルム
  float Norm() {
    return sqrt(x * x + y * y);
  }
  // 単位ベクトル
  D2T Unit() {
    D2T C;
    C = new D2T();
    C.x = x;
    C.y = y;
    C.x /= Norm();
    C.y /= Norm();
    return C;
  }
  // スカラ倍
  D2T Scale(float A) {
    D2T C;
    C = new D2T();
    C.x = x * A;
    C.y = y * A;
    return C;
  }
  // 回転行列
  D2T Rot(float a) {
    D2T C;
    C = new D2T();
    C.x = cos(a) * x - sin(a) * y;
    C.y = sin(a) * x + cos(a) * y;
    return C;
  }
}

// 行列（２×２）
class Tm22 {
  boolean InvError;
  float m[][] = new float[2][2];
  // コンストラクタ
  Tm22() { InvError = false; }
  // 転置
  Tm22 trans() {
    Tm22 C;
    C = new Tm22();
    C.m[0][1] = m[1][0];
    C.m[1][0] = m[0][1];
    return C;
  }
  // 逆行列
  Tm22 Inv() {
    Tm22  C;
    float e;
    C = new Tm22();
    InvError = false;
    C.m[0][0] =  m[1][1];
    C.m[0][1] = -m[0][1];
    C.m[1][0] = -m[1][0];
    C.m[1][1] =  m[0][0];
    e = C.m[0][0] * C.m[1][1] - C.m[0][1] * C.m[1][0];
    if (abs(e) < 0.001) {
      C.m[0][0] = C.m[0][1] = C.m[1][0] = C.m[1][1] = 0.0;
      InvError = true;
      return C;
    }
    C.m[0][0] /= e;
    C.m[0][1] /= e;
    C.m[1][0] /= e;
    C.m[1][1] /= e;
    return C;
  }
}

class Tm23 {
  float m[][] = new float[2][3];
}
class Tm32 {
  boolean    InvError;	// 逆行列不可（正則ではない）
  float m[][] = new float [3][2];
  Tm32() {
    InvError = false;
  }
}

// ２×３と３×２行列
class Tm33 {
  Tm32 m32 = new Tm32();
  Tm23 m23 = new Tm23();
  // 転置(1) m23 -> m32
  Tm32 transHV(Tm23 m23) {
    Tm32 m32 = new Tm32();
    int  i, j;
    for (i = 0; i < 2; i++) {
      for (j = 0; j < 3; j++) {
        m32.m[j][i] = m23.m[i][j];
        }
      }
    return m32;
  }
  // 転置(2) m32 -> m23
  Tm23 transVH(Tm32 m32) {
    Tm23  m23 = new Tm23();
    int	i, j;
    for (i = 0; i < 3; i++) {
      for (j = 0; j < 2; j++) {
        m23.m[j][i] = m32.m[i][j];
      }
    }
    return m23;
  }
  // 掛け算(２３×３２行列＝２×２行列）
  Tm22 mult2332(Tm23 m23, Tm32 m32) {
    int  i, j, k;
    Tm22 m22 = new Tm22();
    for (i = 0; i < 2; i++) {
      for (j = 0; j < 2; j++) {
        for (m22.m[i][j] = 0.0, k = 0; k < 3; k++) {
          m22.m[i][j] += m23.m[i][k] * m32.m[k][j];
        }
      }
    }
    return m22;
  }
  // 掛け算(３２×２２行列＝３×２行列）
  Tm32 Mult3222(Tm32 am32, Tm22 m22) {
    Tm32 m32 = new Tm32();
    int  i, j, k;
    for (i = 0; i < 3; i++) {
      for (j = 0; j < 2; j++) {
        for (m32.m[i][j] = 0.0, k = 0; k < 2; k++) {
          m32.m[i][j] += am32.m[i][k] * m22.m[k][j];
        }
      }
    }
    return m32;
  }
  // ２×３の擬似逆行列を３×２へ
  Tm32 Inv() { return Inv(m23); }
  Tm32 Inv(Tm23 A) {
    Tm32 m32 = new Tm32();
    Tm32 At  = new Tm32();
    Tm22 AAt = new Tm22();
    Tm22 AAti= new Tm22();

    m32.InvError = false;
    At  = transHV(A);	      // At
    AAt = mult2332(A, At);    // AAt
    AAti= AAt.Inv();          // (AAt)^(-1)
    m32 = Mult3222(At, AAti); // At (AAt)^(-1)
    if (AAt.InvError == true) m32.InvError = true;
    return m32;
  }
}

