////////////////////////////////////////////////////////////////////////////////
// あると便利な汎用関数（Crowbar/Tomahawkでも使用しているので削除しないで下さい）
////////////////////////////////////////////////////////////////////////////////

//  1. int sgn(float), int sgn(int)                 : 負ならば-1，正ならば 1，ゼロならば 0 を返す
//  2. String nowDateTime(void)                     : 日時を文字列で返す（yyyy/mm/dd hh:mm:ss）
//  3. char getKEY(void)                            : キーボードから入力された文字を大文字に変換して返す(a-zの場合のみ)
//  4. boolean isNumberChar(char)                   : charが'0'から'9'ならば真
//  5. String strRight(String, int)                 : 文字列の右から指定された長さの文字列を返す
//  6. String strLeft(String, int)                  : 文字列の左から指定された長さの文字列を返す
//  7. float rotate2Dx(float x, float y, float rad) : 二次元平面における回転行列（ｘ軸成分）
//     float rotate2Dy(float x, float y, float rad) : 二次元平面における回転行列（ｙ軸成分）
//  8. float norm(float x0, float y0, float x1, float y1) : 二次元平面における二点間の距離（ユークリッドノルム）を求める
//  9. float [2] polygonGx(float [][] pt)           : 多角形の図心を求める
// 10. float triangleSurface(float x1, float y1, float x2, float y2, float x3, float y3) : 三角形の面積を求める
// 11. float [2] triangleG(float x1, float y1, float x2, float y2, float x3, float y3)   : 三角形の図心を求める
// 12. void _debugPrint(String str)                         : デバッグ用のテキスト出力
//     void _debugPrintln(String str), void _debugPrintln()

// 1. int sgn(float), int sgn(int) : 負ならば-1，正ならば 1，ゼロならば 0 を返す
int sgn(int i) {
  return sgn(float(i));
}
int sgn(float f) {
  if (f < 0.0) return -1;
  if (f > 0.0) return  1;
  return 0;
}

// 2. String nowDateTime() : 日時を文字列で返す（yyyy/mm/dd hh:mm:ss）
String nowDateTime() {
  return str(year()) + '/' + strRight('0' + str(month()), 2) + '/' + strRight('0' + str(day()), 2) + ' ' + strRight('0' + str(hour()), 2) + ':' + strRight('0' + str(minute()), 2) + ':' + strRight('0' + str(second()), 2);
}

// 3. char getKEY() : キーボードから入力された文字を大文字に変換して返す(a-zの場合のみ)
char getKEY() {
  if ((key < 'a') || (key > 'z')) return key;
  return str(key).toUpperCase().charAt(0);
}

// 4. boolean isNumberChar(char)    : charが'0'から'9'ならば真
boolean isNumberChar(char c) {
  if ((c >= '0') && (c <= '9')) return true;
  return false;
}

// 5. String strRight(String, int) : 文字列の右から指定された長さの文字列を返す
String strRight(String str, int len) {
  int  index;
  index = str.length() - len;
  if (index < 0) return str;
//return str.substring(index, len);
  return str.substring(index);
}

// 6. String strLeft(String, int)  : 文字列の左から指定された長さの文字列を返す
String strLeft(String str, int len) {
  return str.substring(0, len);
}

// 7. float rotate2Dx(float x, float y, float rad) : 二次元平面における回転行列（ｘ軸成分）
//    float rotate2Dy(float x, float y, float rad): 二次元平面における回転行列（ｙ軸成分）
float rotate2Dx(float x, float y, float rad) {
  return x * cos(rad) - y * sin(rad);
}
float rotate2Dy(float x, float y, float rad) {
  return x * sin(rad) + y * cos(rad);
}

// 8. float norm(float x0, float y0, float x1, float y1) : 二次元平面における二点間の距離（ユークリッドノルム）を求める
float norm(float x0, float y0, float x1, float y1) {
  float dx, dy;
  dx = x1 - x0;
  dy = y1 - y0;
  return sqrt(dx * dx + dy * dy);
}

// 9. float [2] polygonG(float [][] pt) : 多角形の図心を求める
// http://homepage1.nifty.com/gfk/polygon-G.htm
float [] polygonG(float [][] pt) {
  // 回答の領域確保
  float [] xyG = new float[2];
  xyG[0] = pt[0][0];
  xyG[1] = pt[0][1];
  // １点の場合は何もしない
  if (pt.length == 2) {
    // 二点の場合は中点
    xyG[0] += pt[1][0];
    xyG[1] += pt[1][1];
    xyG[0] /= 2.0;
    xyG[1] /= 2.0;
  } else if (pt.length == 3) {
    // 三点の場合は平均
    xyG = triangleG(pt[0][0], pt[0][1], pt[1][0], pt[1][1], pt[2][0], pt[2][1]);
  } else {
    float St;    // 全面積
    float Si;    // 各三角形の面積
    float [] xyGi = new float[2];  // 各三角形の重心
    int    i;
    // 頂点の複製（＋１個）を作成する：効率は悪いが参照元に悪影響を与えないために
    float p[][] = new float[pt.length + 1][2];
    for (i = 0; i < pt.length; i++) {
      p[i][0] = pt[i][0];
      p[i][1] = pt[i][1];
    }
    p[i][0] = pt[0][0];
    p[i][1] = pt[0][1];
    // 重心を求める
    St = 0.0;
    xyG[0] = xyG[1] = 0.0;
    for (i = 0; i < pt.length; i++) {
//    Si = triangleSurface(0.0, 0.0, p[i][0], p[i][1], p[i+1][0], p[i+1][1]);  // 負の面積が重要らしい
      Si = (p[i][0] * p[i+1][1] - p[i][1] * p[i+1][0]) / 2.0;
      St += Si;
      xyGi = triangleG(0.0, 0.0, p[i][0], p[i][1], p[i+1][0], p[i+1][1]);
      xyG[0] += xyGi[0] * Si;
      xyG[1] += xyGi[1] * Si;
    }
    xyG[0] /= St;
    xyG[1] /= St;
  }
  return xyG;
}

// 10. float triangleSurface(float x1, float y1, float x2, float y2, float x3, float y3) : 三角形の面積を求める
float triangleSurface(float x1, float y1, float x2, float y2, float x3, float y3) {
  float s;
  x1 -= x3;
  y1 -= y3;
  x2 -= x3;
  y2 -= y3;
  s = (x1 * y2 - y1 * x2) / 2.0;
  return s < 0.0 ? -s : s;
}

// 11. float [2] triangleG(float x1, float y1, float x2, float y2, float x3, float y3)   : 三角形の図心を求める
float [] triangleG(float x1, float y1, float x2, float y2, float x3, float y3) {
  float [] xyG = new float[2];
  xyG[0] = (x1 + x2 + x3) / 3.0;
  xyG[1] = (y1 + y2 + y3) / 3.0;
  return xyG;
}

// 12. void _debugPrint(String str) : デバッグ用のテキスト出力
//     void _debugPrintln(String str), void _debugPrintln()
void _debugPrint(String str) {
  if (_DEBUGFLAG) print(str);
}
void _debugPrintln(String str) {
  if (_DEBUGFLAG) println(str);
}
void _debugPrintln() {
  if (_DEBUGFLAG) println();
}

