package matre;

import java.io.Serializable;

public class Day implements Serializable {
    private static final long serialVersionUID = 1L;
    public int code;
    public int date;
    public int o,h,l,c,v,d;
    
    public boolean isYosen() {
        return o<c;
    }
    
    public boolean isInsen() {
        return o>c;
    }
    
    public void split(int n) {
        o /= n;
        h /= n;
        l /= n;
        c /= n;
        v *= n;
        d /= n;
    }
    
    public String toString() {
        return "" + code + ':' + date + ':' + o + ':' + h + ':' + l + ':' + c + ':' + v + ':' + d;
    }
    
    public static boolean isHarami(Day day1, Day day2) {
        return day1.h > day2.h && day1.l < day2.l;
    }
    
    public static boolean isHaramiPure(Day day1, Day day2) {
        int h1 = Util.max(day1.o, day1.c);
        int l1 = Util.min(day1.o, day1.c);
        int h2 = Util.max(day2.o, day2.c);
        int l2 = Util.min(day2.o, day2.c);
        return day1.h > day2.h && day1.l < day2.l && h1 > h2 && l1 < l2;
    }
    
    public static boolean isHaramiPure2(Day day1, Day day2) {
        int h1 = Util.max(day1.o, day1.c);
        int l1 = Util.min(day1.o, day1.c);
        return h1 > day2.h && l1 < day2.l;
    }
    
    public static boolean isGyakuHaramiDown(Day day1, Day day2) {
        return day1.h < day2.h && day1.l > day2.c && day1.isYosen() && day2.isInsen();
    }
    
    public static boolean isGyakuHaramiUp(Day day1, Day day2) {
        return day1.l > day2.l && day1.h < day2.c && day1.isInsen() && day2.isYosen();
    }
}
