package matre.calculate;

import matre.Code;
import matre.Day;
import qdbm.Villa;
import qdbm.VillaException;

public class RSI {
    private int span;
    private Villa days;
    private Villa rsiVilla;
    
    public RSI(int span) throws VillaException {
        this.span = span;
        days = new Villa("days", Villa.OREADER, Villa.CMPOBJ);
        rsiVilla = new Villa("rsi" + span, Villa.OWRITER | Villa.OCREAT, Villa.CMPOBJ);
    }
    
    
    public void calculate(int code) throws VillaException {
        int[] dring = new int[span];
        int sumup = 0;
        int sumdn = 0; 

        long startobj = code*100000000L;
        long endobj = startobj + 100000000L;
        days.curjumpobj(startobj, Villa.JFORWARD);

        for (int i=0;; i++) {
            int ipspan = i%span;
            long k = (Long) days.curkeyobj();
            Day day = (Day) days.curvalobj();

            if (k >= endobj) break;

            double rsi = 0;
            int d = day.d;

            if (d > 0) {
                sumup += d;
            }
            else {
                sumdn -= d;
            }

            if (i >= span) {
                if (dring[ipspan] > 0) {
                    sumup -= dring[ipspan];
                }
                else {
                    sumdn += dring[ipspan];
                }
                rsi = sumup / (double) (sumup + sumdn);
                rsiVilla.putobj(k, rsi, Villa.DOVER);
            }

            dring[ipspan] = d;
            try {
                days.curnext();
            }
            catch (VillaException e) {
                break;
            }
        }
    }

    public void close() throws VillaException {
        rsiVilla.close();
        days.close();
    }
    
    public static void main(String[] args) throws Exception {
        RSI rsi = null;
        try {
            rsi = new RSI(9);
            for (int code : Code.topix100) {
                rsi.calculate(code);
            }
        }
        finally {
            if (rsi != null)
                rsi.close();
        }
        VR.main(null);
    }
}
