package matre.calculate;

import matre.Code;
import matre.Day;
import qdbm.Villa;
import qdbm.VillaException;

public class VR {
    private int span;
    private Villa days;
    private Villa vrVilla;
    
    public VR(int span) throws VillaException {
        this.span = span;
        days = new Villa("days", Villa.OREADER, Villa.CMPOBJ);
        vrVilla = new Villa("vr" + span, Villa.OWRITER | Villa.OCREAT, Villa.CMPOBJ);
    }
    
    
    public void calculate(int code) throws VillaException {
        int[] dring = new int[span];
        int[] vring = new int[span];
        int sumUp = 0;
        int sumAll = 0; 

        long startobj = code*100000000L;
        long endobj = startobj + 100000000L;
        days.curjumpobj(startobj, Villa.JFORWARD);

        for (int i=0;; i++) {
            int ipspan = i%span;
            long k = (Long) days.curkeyobj();
            Day day = (Day) days.curvalobj();

            if (k >= endobj) break;

            int d = day.d;
            int v = day.v;

            if (d > 0) {
                sumUp += v;
            }
            else if (d==0) {
                sumUp += v/2;
            }
            sumAll += v;

            if (i >= span) {
                if (dring[ipspan] > 0) {
                    sumUp -= vring[ipspan];
                }
                else if (dring[ipspan] == 0) {
                    sumUp -= vring[ipspan]/2;
                }
                sumAll -= vring[ipspan];
                
                double vr = sumUp / (double) sumAll;
                //System.out.println(Util.kToString(k) + '\t' + d + '\t' + v + '\t' + vr);
                vrVilla.putobj(k, vr, Villa.DOVER);
            }

            dring[ipspan] = d;
            vring[ipspan] = v;
            try {
                days.curnext();
            }
            catch (VillaException e) {
                break;
            }
        }
    }

    public void close() throws VillaException {
        vrVilla.close();
        days.close();
    }
    
    public static void main(String[] args) throws Exception {
        VR vr = null;
        try {
            vr = new VR(9);

            for (int code : Code.topix100) {
                vr.calculate(code);
            }
        }
        finally {
            if (vr != null)
                vr.close();
        }
    }
}
