package matre.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;

import matre.Code;
import matre.Day;
import matre.Util;
import qdbm.Villa;
import qdbm.VillaException;

public class ImportQdbm {
    private Pattern comma = Pattern.compile(",");

    public void importCsv() throws VillaException {
        File dataDir = new File("data");
        Villa days = null;
        int[] last = new int[10000];

        for (File file : dataDir.listFiles(new CsvFilter())) {
            System.out.println(file.getName());
            BufferedReader r;
            try {
                days = new Villa("days", Villa.OWRITER | Villa.OCREAT, Villa.CMPOBJ);

                r = new BufferedReader(new FileReader(file));

                for (String line; (line = r.readLine())!=null; ) {
                    try {
                        String[] splited = comma.split(line);
                        int code = Integer.parseInt(splited[1]);
                        
                        if (!Code.isTopix100(code)) {
                            continue;
                        }

                        Day day = new Day();
                        
                        day.code = code;
                        day.date = Util.yyyymmdd(splited[0]);
                        day.o = Integer.parseInt(splited[2]);
                        day.h = Integer.parseInt(splited[3]);
                        day.l = Integer.parseInt(splited[4]);
                        day.c = Integer.parseInt(splited[5]);
                        day.v = Integer.parseInt(splited[6]);
                        
                        if (code == 6594 && day.date < 20050927) {
                            day.split(2);
                        }
                        
                        if (last[code] == 0) {
                            day.d = 0;
                        }
                        else {
                            day.d = day.c - last[code];
                        }
                        last[code] = day.c;
                        
                        long key = code * 100000000L + day.date;
                        days.putobj(key, day, Villa.DOVER);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                }
                days.close();
            }
            catch (IOException ioe) {}
        }
        
    }
    public static void main(String[] args) throws Exception {
        new ImportQdbm().importCsv();
    }
    
}
