package matre.simulate;

import java.util.List;

import matre.Day;
import matre.simulate.Result.PositionType;
import qdbm.Villa;
import qdbm.VillaException;

public class GyakuHarami extends Simulator {
    private Villa dVilla;
    private Villa rVilla;
    
    public GyakuHarami() throws VillaException {
        dVilla = new Villa("days", Villa.OREADER, Villa.CMPOBJ);
        rVilla = new Villa("rsi9", Villa.OREADER, Villa.CMPOBJ);
    }
    
    public void simulate(int code, List<Result> results) throws VillaException {
        int buy = 0;
        int sel = 0;
        long startobj = code*100000000L;
        long endobj = startobj + 100000000L;
        dVilla.curjumpobj(startobj, Villa.JFORWARD);

        Day pday = new Day();
        pday.h = pday.l = 0;

        for (;;) {
            long k = (Long) dVilla.curkeyobj();
            //int code = (int)(k / 100000000L);
            Day day = (Day) dVilla.curvalobj();

            // ʕ\
            if (buy != 0) {
                Result r = new Result(PositionType.B, k, buy, day.o);
                results.add(r);
            }
            else if (sel != 0) {
                Result r = new Result(PositionType.S, k, sel, day.o);
                results.add(r);
            }

            buy = sel = 0;
            if (k >= endobj) break;

            try {
                if (Day.isGyakuHaramiUp(pday, day)) {
                    rVilla.curjumpobj(k, Villa.JFORWARD);
                    rVilla.curprev();
                    double rsi = (Double) rVilla.curvalobj();
                    if (rsi < 0.3) {
                        buy = day.c;
                    }
                }
                if (Day.isGyakuHaramiDown(pday, day)) {
                    rVilla.curjumpobj(k, Villa.JFORWARD);
                    rVilla.curprev();
                    double rsi = (Double) rVilla.curvalobj();
                    if (rsi > 0.7) {
                        sel = day.c;
                    }
                }
            }
            catch (VillaException e) {}
            
            pday = day;

            try {
                dVilla.curnext();
            }
            catch (VillaException e) {
                break;
            }
        }
    }

    private static boolean isInPer(Day day, double rate) {
        int d = day.d;
        if (d < 0) d = -d;
        return d/rate < day.c;
    }

    private static boolean isIn1Per(Day day) {
        int d = day.d;
        if (d < 0) d = -d;
        return d*100 < day.c;
    }
    
    public void close() throws VillaException {
        dVilla.close();
        rVilla.close();
    }
    
    public static void main(String[] args) throws Exception {
        GyakuHarami hrsi = new GyakuHarami();
        hrsi.simulate();
    }

}
