package matre.simulate;

import java.util.List;

import matre.Day;
import matre.Util;
import matre.simulate.Result.PositionType;
import qdbm.Villa;
import qdbm.VillaException;

public class HaramiRsi extends Simulator {
    private Villa dVilla;
    private Villa rVilla;
    private Villa vVilla;
    
    public HaramiRsi() throws VillaException {
        dVilla = new Villa("days", Villa.OREADER, Villa.CMPOBJ);
        rVilla = new Villa("rsi9", Villa.OREADER, Villa.CMPOBJ);
        vVilla = new Villa("vr9", Villa.OREADER, Villa.CMPOBJ);
    }
    
    public void simulate(int code, List<Result> results) throws VillaException {
        final double rsiB = 0.4d;
        final double rsiT = 0.6d;
        final double vrB = 0.3d;
        final double vrT = 0.7d;
        int buy = 0;
        int sel = 0;
        long startobj = code*100000000L;
        long endobj = startobj + 100000000L;
        dVilla.curjumpobj(startobj, Villa.JFORWARD);

        Day pday = new Day();
        pday.h = pday.l = 0;

        for (;;) {
            long k = (Long) dVilla.curkeyobj();
            Day day = (Day) dVilla.curvalobj();

            // ʕ\
            if (buy != 0) {
                Result r = new Result(PositionType.B, k, buy, day.o);
                results.add(r);
            }
            else if (sel != 0) {
                Result r = new Result(PositionType.S, k, sel, day.o);
                results.add(r);
            }

            buy = sel = 0;
            if (k >= endobj) break;
            //if (Day.isHaramiPure2(pday, day) && isInPer(day, 0.005)) {
            //if (Day.isHaramiPure2(pday, day) && isIn1Per(day) && pday.v > day.v) {
            //if (Day.isHaramiPure(pday, day) && isInPer(day, 0.05) && pday.v < day.v) {
            //if (Day.isHaramiPure(pday, day) && isInPer(day, 0.05) && pday.v > day.v) {
            //if (Day.isHaramiPure(pday, day) && isInPer(day, 0.1) && pday.v > day.v) {
            if (Day.isHaramiPure(pday, day)) {
                try {
                    rVilla.curjumpobj(k, Villa.JFORWARD);
                    rVilla.curprev();
                    double rsi = (Double) rVilla.curvalobj();

                    vVilla.curjumpobj(k, Villa.JFORWARD);
                    vVilla.curprev();
                    double vr  = (Double) vVilla.curvalobj();
                
                    //System.out.println(Util.kToString(k) + '\t' + rsi + '\t' + vr);
                    //if (pday.isInsen() && day.isYosen() && vr <= 0.3 && rsi <= 0.4) {
                    //if (pday.isInsen() && day.isYosen() && (rsi < 0.4)) {
                    if (pday.isInsen() && day.isYosen() && (rsi < 0.3)) {
                        buy = day.c;
                    }
                    //else if (pday.isYosen() && day.isInsen() && rsi > 0.6 && vr > 0.7) {
                    //else if (pday.isYosen() && day.isInsen() && (rsi > 0.6)) {
                    else if (pday.isYosen() && day.isInsen() && (rsi > 0.7)) {
                        sel = day.c;
                    }
                }
                catch (VillaException e) {
                }
            }
            pday = day;

            try {
                dVilla.curnext();
            }
            catch (VillaException e) {
                break;
            }
        }
    }

    private static boolean isInPer(Day day, double rate) {
        int d = day.d;
        if (d < 0) d = -d;
        return d/rate < day.c;
    }

    private static boolean isIn1Per(Day day) {
        int d = day.d;
        if (d < 0) d = -d;
        return d*100 < day.c;
    }
    
    public void close() throws VillaException {
        rVilla.close();
        vVilla.close();
        dVilla.close();
    }
    
    public static void main(String[] args) throws Exception {
        HaramiRsi hrsi = new HaramiRsi();
        hrsi.simulate();
    }

}
