package matre.simulate;

import matre.Util;

public class Result {
    public enum PositionType {
        B,
        S,
    }
    
    public PositionType positionType;
    public long key;
    public int positionPrice;
    public int settlePrice;
    public int gain;
    public double rate;

    public Result(PositionType positionType, long key, int positionPrice, int settlePrice) {
        this.positionType = positionType;
        this.key = key;
        this.positionPrice = positionPrice;
        this.settlePrice = settlePrice;

        this.gain = (positionType == PositionType.B) ? settlePrice-positionPrice : positionPrice-settlePrice;
        this.rate = (double)(positionPrice+gain)/positionPrice;
    }
    
    public String toString() {
            
        return String.format("%s %s\t%d%d\t%d\t% 2.2f",
                positionType,
                Util.kToString(key),
                positionPrice, 
                settlePrice,
                gain,
                (rate-1.0)*100.0);
    }

}
