package matre.simulate;

import java.util.ArrayList;
import java.util.List;

import matre.Code;

public abstract class Simulator {

    public abstract void simulate(int code, List<Result> results) throws Exception;
    public abstract void close() throws Exception;
   
    protected void simulate() {
        List<Result> results = new ArrayList<Result>();
        try {
            for (int code : Code.topix100) {
                simulate(code, results);
            }
            /*
            for (int code : Code.etf) {
                simulate(code, results);
            }
            */
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            double resultAve = 0.0d;
            double resultTotal = 1.0d;
            for (Result result : results) {
                System.out.println(result);
                resultAve += result.rate;
                resultTotal *= result.rate;
            }
            System.out.println(100*resultAve/results.size()-100);
            System.out.println(resultTotal);
            try {
                close();
            }
            catch (Exception e) {}
        }
    }
}
