(*
 * Copyright (C) 2002 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobO.
 *
 * ÍobO is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobO is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
unit DecryptThreadUnit;

interface

uses
  Classes, SysUtils, ComCtrls, KeyUnit, DecryptFormUnit, InputTextFormUnit;

type
  TDecryptThread = class(TThread)
  private
    { Private 錾 }
    FSecKey: TSecKey;
    FInFileName,
    FOutFileName: string;
    FInStream,
    FOutStream: TStream;
    FForm: TDecryptForm;
    FTextForm: TInputTextForm;
  protected
    procedure Execute; override;
    procedure OnProgress(Sender: TObject);
    procedure UpdateForm;
    procedure ShowTextForm;
  public
    constructor Create(CreateSuspended: Boolean; SecKey: TSecKey; Passwd, InFileName, OutFileName: string; DecryptForm: TDecryptForm); overload;
    constructor Create(CreateSuspended: Boolean; SecKey: TSecKey; Passwd, InFileName: string; TextForm: TInputTextForm; DecryptForm: TDecryptForm); overload;
    destructor Destroy; override;
    property OutStream: TStream read FOutStream;
  end;

implementation

{:
  قȂXbhL VCL ܂ CLX ̃\bh/֐/
  vpeBʂ̃Xbh̒爵ꍇAr̖肪
  ܂B

  CXbh̏LIuWFNgɑ΂Ă Synchronize
  \bhgł܂B̃IuWFNgQƂ邽
  ̃\bhXbhNXɒǉASynchronize \bh
  Ƃēn܂B

  Ƃ΁AUpdateCaption \bhȉ̂悤ɒ`A

    procedure TEncryptThread.UpdateCaption;
    begin
      Form1.Caption := 'TEncryptThread Xbh珑܂';
    end;

  Execute \bh̒ Synchronize \bhɓnƂŃC
  XbhL Form1  Caption vpeBSɕ
  Xł܂B

      Synchronize(UpdateCaption);
}

{ TEncryptThread }

procedure TDecryptThread.Execute;
var
  LH: TLiteralPacketHeader;
begin
  { ToDo : XbhƂĎsR[h̉ɋLqĂ }
  LH := TLiteralPacketHeader.Create;
  try
    FSecKey.OnProgress := OnProgress;
    FSecKey.DecodeFile(FInStream, FOutStream, LH);
    
    if FTextForm <> nil then
      Synchronize(ShowTextForm);
  finally
    LH.Free;
  end;
end;

procedure TDecryptThread.OnProgress(Sender: TObject);
begin
  Synchronize(UpdateForm);
end;

procedure TDecryptThread.UpdateForm;
begin
  if FInStream.Position = FInStream.Size then
  begin
    FForm.FilePosLabel.Caption := 'I';
    FForm.ExitButton.Caption   := '(&C)';
  end
  else
  begin
    FForm.FilePosLabel.Caption := IntToStr(FInStream.Position) + ' oCgς';
  end;

  if FInStream.Size <> 0 then
    FForm.ProgressBar.Position := Trunc((FInStream.Position / FInStream.Size) * 100)
  else
    FForm.ProgressBar.Position := 100;
end;

procedure TDecryptThread.ShowTextForm;
begin
  FOutStream.Position := 0;
  FTextForm.Memo.Text := IntToStr(FOutStream.Size);
  FTextForm.Memo.Lines.LoadFromStream(FOutStream);
  FTextForm.Memo.Lines.Text := UTF8Decode(FTextForm.Memo.Lines.Text);
end;

constructor TDecryptThread.Create(CreateSuspended: Boolean; SecKey: TSecKey; Passwd, InFileName, OutFileName: string; DecryptForm: TDecryptForm);
var
  MS: TMemoryStream;
begin
  inherited Create(CreateSuspended);

  FSecKey      := TSecKey.Create;
  FInFileName  := InFileName;
  FOutFileName := OutFileName;
  FInStream    := TFileStream.Create(FInFileName, fmOpenRead or fmShareExclusive);
  FOutStream   := TFileStream.Create(FOutFileName, fmCreate or fmShareExclusive);
  FForm        := DecryptForm;
  FTextForm    := nil;

  FForm.InFileNameLabel.Caption  := ExtractFileName(FInFileName);
  FForm.OutFileNameLabel.Caption := ExtractFileName(FOutFileName);
  FForm.FileSizeLabel.Caption := IntToStr(FInStream.Size) + ' oCg';
  FForm.FilePosLabel.Caption  := 'Í̏...';
  FForm.ExitButton.Caption    := '~(&A)';

  MS := TMemoryStream.Create;
  try
    SecKey.SaveToStream(MS);
    MS.Position := 0;
    FSecKey.LoadFromStream(MS);
    FSecKey.Unlock(Passwd);
  finally
    MS.Free;
  end;
end;

constructor TDecryptThread.Create(CreateSuspended: Boolean; SecKey: TSecKey; Passwd, InFileName: string; TextForm: TInputTextForm; DecryptForm: TDecryptForm);
var
  MS: TMemoryStream;
begin
  inherited Create(CreateSuspended);
  
  FSecKey      := TSecKey.Create;
  FInFileName  := InFileName;
  FOutFileName := '';
  FInStream    := TFileStream.Create(FInFileName, fmOpenRead or fmShareExclusive);
  FOutStream   := TMemoryStream.Create;
  FForm        := DecryptForm;
  FTextForm    := TextForm;

  FForm.InFileNameLabel.Caption  := ExtractFileName(FInFileName);
  FForm.OutFileNameLabel.Caption := ExtractFileName(FOutFileName);
  FForm.FileSizeLabel.Caption := IntToStr(FInStream.Size) + ' oCg';
  FForm.FilePosLabel.Caption  := 'Í̏...';
  FForm.ExitButton.Caption    := '~(&A)';

  MS := TMemoryStream.Create;
  try
    SecKey.SaveToStream(MS);
    MS.Position := 0;
    FSecKey.LoadFromStream(MS);
    FSecKey.Unlock(Passwd);
  finally
    MS.Free;
  end;
end;

destructor TDecryptThread.Destroy;
begin
  FOutStream.Free;
  FInStream.Free;
  FSecKey.Free;
  inherited;
end;

end.
