(*
 * Copyright (C) 2002,2004 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobO.
 *
 * ÍobO is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobO is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
unit MainFromUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, ShellCtrls, InputFrameUnit,
  ProgressFrameUnit, DoneFrameUnit, Menus, ActnList, GenKeyThreadUnit;

type
  TState = (tsInput, tsProgress, tsDone);
  TMainForm = class(TForm)
    DoneFrame: TDoneFrame;
    ProgressFrame: TProgressFrame;
    InputFrame: TInputFrame;
    TopPanel: TPanel;
    Image1: TImage;
    StatusBar: TStatusBar;
    Bevel1: TBevel;
    Label2: TLabel;
    Label1: TLabel;
    InputLabel: TLabel;
    GoProgressLabel: TLabel;
    ProgressLabel: TLabel;
    GoDoneLabel: TLabel;
    DoneLabel: TLabel;
    MainMenu1: TMainMenu;
    Help1: TMenuItem;
    About1: TMenuItem;
    Bevel2: TBevel;
    File1: TMenuItem;
    ExitMenu: TMenuItem;
    ActionList: TActionList;
    ExitAction: TAction;
    GenKeyAction: TAction;
    CancelGenKeyAction: TAction;
    AboutAction: TAction;
    procedure FormCreate(Sender: TObject);
    procedure ExitActionExecute(Sender: TObject);
    procedure GenKeyActionExecute(Sender: TObject);
    procedure CancelGenKeyActionExecute(Sender: TObject);
    procedure AboutActionExecute(Sender: TObject);
  private
    { Private 錾 }
    FState: TState;
    FGenKeyThread: TGenKeyThread;
  protected
    procedure SetState(Value: TState);
    function CheckInputValue: Boolean;
    procedure GenNewKey;
    procedure OnGenNewKeyTerminate(Sender: TObject);
  public
    { Public 錾 }
    property State: TState read FState write SetState;
  end;

var
  MainForm: TMainForm;

implementation

uses AboutFormUnit;

{$R *.dfm}

procedure TMainForm.SetState(Value: TState);
begin
  FState := Value;

  InputFrame.Visible    := (Value = tsInput);
  ProgressFrame.Visible := (Value = tsProgress);
  DoneFrame.Visible     := (Value = tsDone);

  case FState of
  tsInput:
    begin
      InputLabel.Enabled   := True;
      StatusBar.SimpleText := 'ÍobO  ÍL[̍쐬ɕKvȏ͂ĉ';
    end;
  tsProgress:
    begin
      GoProgressLabel.Enabled := True;
      ProgressLabel.Enabled   := True;
      StatusBar.SimpleText    := 'ÍobO  ÍL[ ̃yA쐬Ă܂';
      GenNewKey;
    end;
  tsDone:
    begin
      GoDoneLabel.Enabled  := True;
      DoneLabel.Enabled    := True;
      StatusBar.SimpleText := 'VK쐬';
    end;
  end;
end;

function TMainForm.CheckInputValue: Boolean;
var
  FileName: string;
begin
  Result := False;

  if InputFrame.NameEdit.Text   = '' then
  begin
    MessageDlg('O͂Ă܂', mtError, [mbOK], 0);
    Exit;
  end;

  if InputFrame.EMailEdit.Text  = '' then
  begin
    MessageDlg('dq[AhX͂Ă܂', mtError, [mbOK], 0);
    Exit;
  end;

  if InputFrame.PasswdEdit.Text = '' then
  begin
    MessageDlg('pX[h͂Ă܂', mtError, [mbOK], 0);
    Exit;
  end;

  if InputFrame.PasswdEdit.Text <> InputFrame.Passwd1Edit.Text then
  begin
    MessageDlg('pX[h̊mFɓ͂ꂽpX[hقȂ܂', mtError, [mbOK], 0);
    Exit;
  end;

  FileName := InputFrame.FolderTreeView.Path + '\' + InputFrame.NameEdit.Text;
  if FileExists(FileName + '.cbbag') or FileExists(FileName + '.cbkey') then
  begin
    MessageDlg('w肳ꂽfBNgɈÍobOƈÍL[݂܂', mtError, [mbOK], 0);
    Exit;
  end;

  Result := True;
end;

procedure TMainForm.GenNewKey;
var
  FileName, UserID, Passwd: string;
begin
  ProgressFrame.SecKeyFileNameLabel.Caption := InputFrame.NameEdit.Text + '.cbbag';
  ProgressFrame.PubKeyFileNameLabel.Caption := InputFrame.NameEdit.Text + '.cbkey';
  DoneFrame.SecKeyFileNameLabel.Caption := ProgressFrame.SecKeyFileNameLabel.Caption;
  DoneFrame.PubKeyFileNameLabel.Caption := ProgressFrame.PubKeyFileNameLabel.Caption;

  FileName := InputFrame.FolderTreeView.Path + '\' + InputFrame.NameEdit.Text;
  UserId   := InputFrame.NameEdit.Text + ' <' + InputFrame.EMailEdit.Text + '>';
  Passwd   := InputFrame.PasswdEdit.Text;

  FGenKeyThread := TGenKeyThread.Create(FileName, UserID, Passwd, True);
  FGenKeyThread.FreeOnTerminate := True;
  FGenKeyThread.OnTerminate := OnGenNewKeyTerminate;
  FGenKeyThread.Resume;

  ProgressFrame.Animate.Active := True;
end;

procedure TMainForm.OnGenNewKeyTerminate(Sender: TObject);
var
 E: Exception;
begin
  if Sender is TThread then
    if TThread(Sender).FatalException is Exception then
    begin
      E := Exception(TThread(Sender).FatalException);
      MessageDlg('L[̍쐬ŃG[܂' + #13 + E.Message, mtError, [mbAbort], 0);
      Close;
    end;
    
  ProgressFrame.Animate.Active := False;
  State := tsDone;

  MessageDlg('쐬I', mtInformation, [mbOK], 0);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  ClientHeight := InputFrame.ClientHeight + TopPanel.Height + StatusBar.Height;
  ClientWidth  := InputFrame.ClientWidth;
  InputFrame.Align    := alClient;
  ProgressFrame.Align := alClient;
  DoneFrame.Align     := alClient;

  ProgressFrame.Animate.FileName := ExtractFilePath(Application.ExeName) + 'genkey.avi';
  State  := tsInput;
end;

procedure TMainForm.ExitActionExecute(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.GenKeyActionExecute(Sender: TObject);
begin
  if CheckInputValue then
    State := tsProgress;
end;

procedure TMainForm.CancelGenKeyActionExecute(Sender: TObject);
begin
  if MessageDlg('VK쐬𒆎~܂H', mtConfirmation, [mbYes, mbNo], 0) = IDYES then
    Close; 
end;

procedure TMainForm.AboutActionExecute(Sender: TObject);
var
  DLG: TAboutForm;
begin
  DLG := TAboutForm.Create(Self);
  try
    DLG.ShowModal;
  finally
    DLG.Free;
  end;
end;

end.
