/*
QuotedPrintable.cs : Decoding the "Quoted Printable" encoding.
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


using System;
using System.Text;
using System.Text.RegularExpressions;
using System.Globalization;
using System.Collections;

namespace TestWeb
{
	public class QuotedPrintable
	{
		public static byte[] GetBytes(string src)
		{
			// "=3D" Ƃ̕̕R[hɕԂ߂̐K\
			Regex r = new Regex("[=](?<bit1>[0-9a-fA-F])(?<bit2>[0-9a-fA-F])");

			// 75 oCgڂ̕ɖ߂
			string src2 = Regex.Replace(src, "=\r\n", "");

			Match m = r.Match(src2);

			int index = 0;

			// ArrayList  byte zꎞIɓĂ
			ArrayList a = new ArrayList();
			while(m.Success)
			{
				// "=3D" Ȃǂ 3 oCg̕ȑO̕ byte zɂ
				string sub = src2.Substring(index, m.Index - index);
				if(sub != "")
				{
					byte[] bb = Encoding.ASCII.GetBytes(sub);
					foreach(byte b in bb)
					{
						a.Add(b);
					}
				}
				// "=3D" Ȃǂ 3 oCg̕ "3"  "D" 
				string bt = m.Groups["bit1"].Value.ToString() + m.Groups["bit2"].Value.ToString();
				byte bd = byte.Parse(bt, NumberStyles.AllowHexSpecifier);
				a.Add(bd);
				index = m.Index + 3;
				m = m.NextMatch();
			}
			// c̕ byte zɂ
			if(index < src2.Length)
			{
				string sub = src2.Substring(index, src2.Length - index);
				if(sub != "")
				{
					byte[] bb = Encoding.ASCII.GetBytes(sub);
					foreach(byte b in bb)
					{
						a.Add(b);
					}
				}
			}
			byte[] br = new byte[a.Count];
			int c = 0;
			IEnumerator ie = a.GetEnumerator();

			// ArrayList ̒g byte zɓȂ
			while(ie.MoveNext())
			{
				br[c] = (byte)ie.Current;
				c++;
			}
			return br;
		}
	}
}
