/*
Form1.cs : This is Windows Form class. Almost of this source code
 is generated automatically.
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Reflection;
using CSamura.NNTP;
using CSamura.Forms;
using System.Text.RegularExpressions;
using System.Text;
using System.Runtime.Serialization.Formatters.Binary;

namespace CSamura.Forms
{
	/// <summary>
	/// Form1 ̊Tv̐łB
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.Button btnPost;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.TreeView articleTreeView;
		private NewsArticleNodeDictionary articleNodeDictionary;
		private NewsArticleDictionary articleDictionary;


		private PostForm postForm;
		private System.Windows.Forms.TreeView groupTreeView;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem confMenu;
		private System.Windows.Forms.MenuItem itemSGConf;
		private ServerForm serverForm;
		private System.Windows.Forms.Button btnRepost;
		private System.Windows.Forms.Button btnSource;

		private const string filename = "csamuranews.news";

		public Form1()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
			articleNodeDictionary = new NewsArticleNodeDictionary();
			articleDictionary = new NewsArticleDictionary();

		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.btnPost = new System.Windows.Forms.Button();
			this.articleTreeView = new System.Windows.Forms.TreeView();
			this.groupTreeView = new System.Windows.Forms.TreeView();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.confMenu = new System.Windows.Forms.MenuItem();
			this.itemSGConf = new System.Windows.Forms.MenuItem();
			this.btnRepost = new System.Windows.Forms.Button();
			this.btnSource = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(208, 168);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.textBox1.Size = new System.Drawing.Size(392, 240);
			this.textBox1.TabIndex = 0;
			this.textBox1.Text = "";
			this.textBox1.WordWrap = false;
			// 
			// btnPost
			// 
			this.btnPost.Location = new System.Drawing.Point(224, 136);
			this.btnPost.Name = "btnPost";
			this.btnPost.Size = new System.Drawing.Size(80, 24);
			this.btnPost.TabIndex = 2;
			this.btnPost.Text = "Post";
			this.btnPost.Click += new System.EventHandler(this.btnPost_Click);
			// 
			// articleTreeView
			// 
			this.articleTreeView.Font = new System.Drawing.Font("MS UI Gothic", 9F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
			this.articleTreeView.ImageIndex = -1;
			this.articleTreeView.Location = new System.Drawing.Point(208, 8);
			this.articleTreeView.Name = "articleTreeView";
			this.articleTreeView.SelectedImageIndex = -1;
			this.articleTreeView.Size = new System.Drawing.Size(384, 120);
			this.articleTreeView.TabIndex = 3;
			this.articleTreeView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.articleTreeView_AfterSelect);
			// 
			// groupTreeView
			// 
			this.groupTreeView.ImageIndex = -1;
			this.groupTreeView.Location = new System.Drawing.Point(8, 8);
			this.groupTreeView.Name = "groupTreeView";
			this.groupTreeView.SelectedImageIndex = -1;
			this.groupTreeView.Size = new System.Drawing.Size(192, 400);
			this.groupTreeView.TabIndex = 7;
			this.groupTreeView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.groupTreeView_AfterSelect);
			this.groupTreeView.BeforeSelect += new System.Windows.Forms.TreeViewCancelEventHandler(this.groupTreeView_BeforeSelect);
			this.groupTreeView.Leave += new System.EventHandler(this.groupTreeView_Leave);
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.confMenu});
			// 
			// confMenu
			// 
			this.confMenu.Index = 0;
			this.confMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.itemSGConf});
			this.confMenu.Text = "ݒ(&C)";
			// 
			// itemSGConf
			// 
			this.itemSGConf.Index = 0;
			this.itemSGConf.Text = "NNTP T[oƃj[XO[v(&S)";
			this.itemSGConf.Click += new System.EventHandler(this.itemSGConf_Click);
			// 
			// btnRepost
			// 
			this.btnRepost.Location = new System.Drawing.Point(320, 136);
			this.btnRepost.Name = "btnRepost";
			this.btnRepost.Size = new System.Drawing.Size(80, 24);
			this.btnRepost.TabIndex = 8;
			this.btnRepost.Text = "Repost";
			this.btnRepost.Click += new System.EventHandler(this.btnRepost_Click);
			// 
			// btnSource
			// 
			this.btnSource.Location = new System.Drawing.Point(416, 136);
			this.btnSource.Name = "btnSource";
			this.btnSource.Size = new System.Drawing.Size(88, 24);
			this.btnSource.TabIndex = 9;
			this.btnSource.Text = "L̃\[X";
			this.btnSource.Click += new System.EventHandler(this.btnSource_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(608, 414);
			this.Controls.Add(this.btnSource);
			this.Controls.Add(this.btnRepost);
			this.Controls.Add(this.groupTreeView);
			this.Controls.Add(this.articleTreeView);
			this.Controls.Add(this.btnPost);
			this.Controls.Add(this.textBox1);
			this.Menu = this.mainMenu1;
			this.Name = "Form1";
			this.Text = "CSNewsClient 0.0.3.0";
			this.Load += new System.EventHandler(this.Form_Load);
			this.Closed += new System.EventHandler(this.Form1_Closed);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}


		private void btnPost_Click(object sender, System.EventArgs e)
		{
			postForm = new PostForm();
			postForm.Show();

		}

		private void articleTreeView_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			try
			{
				// tHg𑾎׎ɕς
				e.Node.NodeFont = new Font("MS UI Gothic", 9);

				// Im[h̃j[XL擾Awb_eLXg{bNXɓnB
				NewsArticleNode articleNode = articleNodeDictionary.GetNewsArticleNode(((NewsArticleNode)e.Node).ID);
				NewsArticle article = articleNode.GetNewsArticle();

				string msg = "";
				msg += "Message-ID: " + articleNode.ID + "\r\n";
				msg += "M: " + article.GetFrom() + "\r\n";
				msg += "薼: " + article.GetSubject() + "\r\n";
				msg += "M: " + article.GetDate() + "\r\n\r\n";
				if(article.IsBody())
				{
					msg += article.GetDecodedBody();
					textBox1.Text = msg;
				}
				else
				{
					NNTPClient client = new NNTPClient();
					client.NewsConnect("msnews.microsoft.com", 119);
					string body;
					client.GetBody(articleNode.ID, out body);
					client.NewsDisconnect();

					article.SetBody(body);

					msg += article.GetDecodedBody();

					textBox1.Text = msg;
				}
			}
			catch(InvalidCastException){}
		}

		private void Form_Load(object sender, System.EventArgs e)
		{
			DirectoryInfo di = new DirectoryInfo(Application.StartupPath);
			DirectoryInfo[] dsi = di.GetDirectories();
			if(dsi.Length > 0)
			{
				ServerNode[] rnode = new ServerNode[dsi.Length];
				int count = 0;
				foreach(DirectoryInfo d in dsi)
				{
					rnode[count] = new ServerNode(d.Name);
					DirectoryInfo[] di2 = d.GetDirectories();
					
					if(di2.Length > 0)
					{
						NewsGroupNode[] cnode = new NewsGroupNode[di2.Length];
						int count2 = 0;
						foreach(DirectoryInfo d2 in di2)
						{
							cnode[count2] = new NewsGroupNode(d2.Name);
							count2++;
						}
						rnode[count].Nodes.AddRange(cnode);
					}

					count++;
				}
				groupTreeView.Nodes.AddRange(rnode);
			}
			else
			{
				serverForm = new ServerForm();
				if(serverForm.ShowDialog(this) == DialogResult.OK)
				{
					ServerNode[] nodes = serverForm.ReturnNodes;
					if(nodes != null)
					{
						groupTreeView.Nodes.Clear();
						groupTreeView.Nodes.AddRange(nodes);
					}
				}
				serverForm.Dispose();
			}

		}

		private void itemSGConf_Click(object sender, System.EventArgs e)
		{
			serverForm = new ServerForm();
			if(serverForm.ShowDialog(this) == DialogResult.OK)
			{
				groupTreeView.Nodes.Clear();
				ServerNode[] nodes = serverForm.ReturnNodes;
				groupTreeView.Nodes.AddRange(nodes);
			}
			serverForm.Dispose();
		}

		private void groupTreeView_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			try
			{
				NewsGroupNode gnode = (NewsGroupNode)groupTreeView.SelectedNode;
				string fpath = gnode.DirectoryFullPathName + "\\" + filename;
				articleTreeView.Nodes.Clear();
				if(File.Exists(fpath))
				{
					FileStream fs = File.OpenRead(fpath);
					BinaryFormatter bf = new BinaryFormatter();
					articleDictionary = (NewsArticleDictionary)bf.Deserialize(fs);
					fs.Close();
				}
				else
				{
					articleDictionary = new NewsArticleDictionary();
				}
				textBox1.Text = "";
				NNTPClient nntp = new NNTPClient();
				string res = "";
				res += nntp.NewsConnect("msnews.microsoft.com", 119);
				res += nntp.GetHeaders(gnode.NewsGroupName, 
					ref articleTreeView,
					ref articleNodeDictionary,
					ref articleDictionary);

				res += nntp.NewsDisconnect();
				textBox1.AppendText(res);
			}
			catch(InvalidCastException)
			{
				articleTreeView.Nodes.Clear();
			}
			
		}

		private void groupTreeView_BeforeSelect(object sender, System.Windows.Forms.TreeViewCancelEventArgs e)
		{
			try
			{
				NewsGroupNode gnode = (NewsGroupNode)groupTreeView.SelectedNode;

				string fpath = gnode.DirectoryFullPathName + "\\" + filename;
				FileStream fs = File.Create(fpath);

				BinaryFormatter bf = new BinaryFormatter();
				bf.Serialize(fs, articleDictionary);
				fs.Close();
				MessageBox.Show("܂");
			}
			catch(InvalidCastException){}
			catch(NullReferenceException){}
		}

		private void groupTreeView_Leave(object sender, System.EventArgs e)
		{
			try
			{
				NewsGroupNode gnode = (NewsGroupNode)groupTreeView.SelectedNode;

				string fpath = gnode.DirectoryFullPathName + "\\" + filename;
				FileStream fs = File.Create(fpath);

				BinaryFormatter bf = new BinaryFormatter();
				bf.Serialize(fs, articleDictionary);
				fs.Close();
				MessageBox.Show("܂");
			}
			catch(InvalidCastException){}
			catch(NullReferenceException){}
		}

		private void btnRepost_Click(object sender, System.EventArgs e)
		{
			try
			{
				NewsArticleNode node = (NewsArticleNode)articleTreeView.SelectedNode;
				NewsArticle article = node.GetNewsArticle();
				
				postForm = new PostForm();
				postForm.BeforeRepost(article);
				postForm.ShowDialog();
				
			}
			catch(InvalidCastException)
			{
				MessageBox.Show("ԐMLw肵Ă", "CSNewsClient");
			}
		}

		private void btnSource_Click(object sender, System.EventArgs e)
		{
			string a;
			string server = groupTreeView.SelectedNode.Parent.Text;
			string id = ((NewsArticleNode)articleTreeView.SelectedNode).ID;
			NNTPClient client = new NNTPClient();
			client.NewsConnect(server, 119);
			client.GetArticle(id, out a);
			client.NewsDisconnect();
			MessageBox.Show(a);
		}

		private void Form1_Closed(object sender, System.EventArgs e)
		{
			try
			{
				NewsGroupNode gnode = (NewsGroupNode)groupTreeView.SelectedNode;

				string fpath = gnode.DirectoryFullPathName + "\\" + filename;
				FileStream fs = File.Create(fpath);

				BinaryFormatter bf = new BinaryFormatter();
				bf.Serialize(fs, articleDictionary);
				fs.Close();
				MessageBox.Show("܂");
			}
			catch(InvalidCastException){}
			catch(NullReferenceException){}		
		}
	}
}
