/*
TextCheck.cs : The class for the "static" methods to check the string. 
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Text.RegularExpressions;

namespace CSamura.NNTP
{
	/// <summary>
	/// `FbNp̐ÓI\bhW߂NX
	/// </summary>
	public class TextCheck
	{
		/// <summary>
		/// 2oCg̕񂩂ǂ𔻒肷B
		/// ppApXy[XAJ}AsIhȊOȂ false
		/// </summary>
		/// <param name="src">肷镶</param>
		/// <returns>true: ppApXy[XAJ}AsIĥ,
		/// false: ȊO܂܂Ă</returns>
		public static bool Is2ByteString(string src)
		{
			Regex r = new Regex("^[a-zA-z0-9\\.\\,\\s]+$");
			
			if(r.IsMatch(src)) return true;
			else return false;
		}

	}
}
