/*
ServerForm.cs : Windows Form to configure of the NNTP server
 and the Newsgroups. 
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using CSamura.NNTP;
using CSamura.Forms;

namespace CSamura.Forms
{
	/// <summary>
	/// ServerForm ̊Tv̐łB
	/// </summary>
	public class ServerForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox txtServerName;
		private System.Windows.Forms.Button btnGroups;
		private System.Windows.Forms.TreeView groupsTreeView;
		private System.Windows.Forms.TreeView readingGroupTreeView;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button btnToRead;
		private System.Windows.Forms.Button btnCancelRead;

		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button btnOK;

		private ServerNode[] returnNodes; 


		public ServerForm()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.txtServerName = new System.Windows.Forms.TextBox();
			this.btnGroups = new System.Windows.Forms.Button();
			this.groupsTreeView = new System.Windows.Forms.TreeView();
			this.readingGroupTreeView = new System.Windows.Forms.TreeView();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.btnToRead = new System.Windows.Forms.Button();
			this.btnCancelRead = new System.Windows.Forms.Button();
			this.btnOK = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(152, 24);
			this.label1.TabIndex = 0;
			this.label1.Text = "ǉ NNTP T[o";
			// 
			// txtServerName
			// 
			this.txtServerName.Location = new System.Drawing.Point(176, 8);
			this.txtServerName.Name = "txtServerName";
			this.txtServerName.Size = new System.Drawing.Size(376, 19);
			this.txtServerName.TabIndex = 1;
			this.txtServerName.Text = "msnews.microsoft.com";
			// 
			// btnGroups
			// 
			this.btnGroups.Location = new System.Drawing.Point(72, 32);
			this.btnGroups.Name = "btnGroups";
			this.btnGroups.Size = new System.Drawing.Size(288, 23);
			this.btnGroups.TabIndex = 2;
			this.btnGroups.Text = "j[XO[v̎擾";
			this.btnGroups.Click += new System.EventHandler(this.btnGroups_Click);
			// 
			// groupsTreeView
			// 
			this.groupsTreeView.ImageIndex = -1;
			this.groupsTreeView.Location = new System.Drawing.Point(8, 96);
			this.groupsTreeView.Name = "groupsTreeView";
			this.groupsTreeView.SelectedImageIndex = -1;
			this.groupsTreeView.Size = new System.Drawing.Size(232, 160);
			this.groupsTreeView.TabIndex = 3;
			// 
			// readingGroupTreeView
			// 
			this.readingGroupTreeView.Font = new System.Drawing.Font("MS UI Gothic", 9F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
			this.readingGroupTreeView.ImageIndex = -1;
			this.readingGroupTreeView.Location = new System.Drawing.Point(352, 96);
			this.readingGroupTreeView.Name = "readingGroupTreeView";
			this.readingGroupTreeView.SelectedImageIndex = -1;
			this.readingGroupTreeView.Size = new System.Drawing.Size(240, 160);
			this.readingGroupTreeView.TabIndex = 4;
			this.readingGroupTreeView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.readingGroupTreeView_AfterSelect);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(40, 72);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(168, 23);
			this.label2.TabIndex = 5;
			this.label2.Text = "Ij[XO[ṽXg";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(376, 72);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(168, 24);
			this.label3.TabIndex = 6;
			this.label3.Text = "wǂj[XO[ṽXg";
			// 
			// btnToRead
			// 
			this.btnToRead.Location = new System.Drawing.Point(248, 152);
			this.btnToRead.Name = "btnToRead";
			this.btnToRead.Size = new System.Drawing.Size(88, 24);
			this.btnToRead.TabIndex = 7;
			this.btnToRead.Text = "w  >>";
			this.btnToRead.Click += new System.EventHandler(this.btnToRead_Click);
			// 
			// btnCancelRead
			// 
			this.btnCancelRead.Location = new System.Drawing.Point(248, 192);
			this.btnCancelRead.Name = "btnCancelRead";
			this.btnCancelRead.Size = new System.Drawing.Size(88, 24);
			this.btnCancelRead.TabIndex = 8;
			this.btnCancelRead.Text = "<< wǉ";
			this.btnCancelRead.Click += new System.EventHandler(this.btnCancelRead_Click);
			// 
			// btnOK
			// 
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(312, 272);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(104, 32);
			this.btnOK.TabIndex = 9;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// button2
			// 
			this.button2.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.button2.Location = new System.Drawing.Point(456, 272);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(112, 32);
			this.button2.TabIndex = 10;
			this.button2.Text = "LZ";
			// 
			// ServerForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(600, 318);
			this.Controls.Add(this.button2);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancelRead);
			this.Controls.Add(this.btnToRead);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.readingGroupTreeView);
			this.Controls.Add(this.groupsTreeView);
			this.Controls.Add(this.btnGroups);
			this.Controls.Add(this.txtServerName);
			this.Controls.Add(this.label1);
			this.Name = "ServerForm";
			this.Text = "NNTP T[oƃj[XO[v̐ݒ";
			this.Load += new System.EventHandler(this.Form_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void btnGroups_Click(object sender, System.EventArgs e)
		{
			if(txtServerName.Text.Length > 0)
			{
				this.OpenGroups(txtServerName.Text, false);
			}

		}

		private void btnToRead_Click(object sender, System.EventArgs e)
		{
			ServerNode pnode;
			NewsGroupNode pgnode;
			try
			{
				pgnode = (NewsGroupNode)groupsTreeView.SelectedNode;
				pnode = (ServerNode)groupsTreeView.SelectedNode.Parent;
			}
			catch(NullReferenceException)
			{
				return;
			}

			IEnumerator ie = readingGroupTreeView.Nodes.GetEnumerator();
			while(ie.MoveNext())
			{
				ServerNode xnode = (ServerNode)ie.Current;
				if(xnode.NNTPServerName == pnode.NNTPServerName)
				{
					IEnumerator ieg = xnode.Nodes.GetEnumerator();
					while(ieg.MoveNext())
					{
						NewsGroupNode xgnode = (NewsGroupNode)ieg.Current;
						// j[XO[vłɍwǂĂ΁AI
						if(xgnode.NewsGroupName == pgnode.NewsGroupName)
						{
							return;
						}
					}
					// j[XO[v܂wǂĂȂ΁A
					// j[XO[ṽm[hǉ
					NewsGroupNode newgnode = new NewsGroupNode(pgnode.NewsGroupName);

					// j[XO[ṽfBNg݂Ă΁A
					// tHg׎ɂ
					if(Directory.Exists(pgnode.DirectoryFullPathName))
					{
						newgnode.NodeFont = new Font("MS UI Gothic", 9);
					}
					xnode.Nodes.Add(newgnode);
				}

			}
		}

		private void btnCancelRead_Click(object sender, System.EventArgs e)
		{
			try
			{
				TreeNode gnode = readingGroupTreeView.SelectedNode;
				gnode.Remove();
				gnode = null;
			}
			catch(InvalidCastException)
			{}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			IEnumerator iserver = readingGroupTreeView.Nodes.GetEnumerator();
			Hashtable rstable = new Hashtable();
			Hashtable rgtable = new Hashtable();

			// VtH_쐬镔
			while(iserver.MoveNext())
			{
				ServerNode psnode = (ServerNode)iserver.Current;

				// NNTP T[õtH_܂ĂȂ΁A쐬B
				if(!Directory.Exists(psnode.DirectoryFullPathName))
				{
					Directory.CreateDirectory(psnode.DirectoryFullPathName);
				}
				rstable.Add(psnode.NNTPServerName, psnode);

				IEnumerator igroups = psnode.Nodes.GetEnumerator();
				while(igroups.MoveNext())
				{
					NewsGroupNode pgnode = (NewsGroupNode)igroups.Current;

					// j[XO[ṽtH_܂ĂȂ΁A쐬B
					if(!Directory.Exists(pgnode.DirectoryFullPathName))
					{
						Directory.CreateDirectory(pgnode.DirectoryFullPathName);
					}
					rgtable.Add(pgnode.DirectoryFullPathName, pgnode);
				}
			}


			// wǉŃtH_폜镔
			DirectoryInfo di = new DirectoryInfo(Application.StartupPath);
			DirectoryInfo[] diss = di.GetDirectories();
			if(diss.Length > 0)
			{
				foreach(DirectoryInfo dis in diss)
				{
					// wǃXgɂȂ NNTP T[õtH_폜
					if(!rstable.ContainsKey(dis.Name))
					{
						if(DialogResult.OK == MessageBox.Show(
							dis.Name + " ̍wǂ܂H",
							"NNTP T[ỏ",
							MessageBoxButtons.OKCancel))
						{
							Directory.Delete(dis.FullName, true);
						}
						else
						{
							MessageBox.Show(dis.Name + "̍wǉLZ܂B",
								"NNTP T[ỏ");
						}
					}
					else
					{
						DirectoryInfo[] digs = dis.GetDirectories();
						if(digs.Length > 0)
						{
							foreach(DirectoryInfo dig in digs)
							{
								// wǃXgɂȂj[XO[ṽtH_폜
								if(!rgtable.ContainsKey(dig.FullName))
								{
									if(DialogResult.OK == MessageBox.Show(
										dig.Name + " ̍wǂ܂H",
										"j[XO[v̍wǉ",
										MessageBoxButtons.OKCancel))
									{
										Directory.Delete(dig.FullName, true);
									}
									else
									{
										MessageBox.Show(dig.Name + "̍wǉLZ܂B",
											"j[XO[v̍wǉ");
									}
								}
							}
						}
					}
				}
			}

			// xAtH_̍\ [T[o -> j[XO[v] ̃c[\擾
			returnNodes = this.GetServerNodes();		
		}

		private void readingGroupTreeView_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			string path;
			try
			{
				path = ((NewsGroupNode)e.Node).DirectoryFullPathName;
			}
			catch(InvalidCastException)
			{
				path = ((ServerNode)e.Node).DirectoryFullPathName;
			}
			MessageBox.Show(path);
		}

		private void Form_Load(object sender, System.EventArgs e)
		{
			ServerNode[] snodes = this.GetServerNodes();
			try
			{
				readingGroupTreeView.Nodes.AddRange(snodes);
			}
			catch(ArgumentNullException)
			{}
		}

		private bool OpenGroups(string server, bool existed)
		{
			if(groupsTreeView.Nodes.Count > 0)
			{
				IEnumerator ie = groupsTreeView.Nodes.GetEnumerator();
				while(ie.MoveNext())
				{
					string name = ((ServerNode)ie.Current).NNTPServerName;
					if(name == server) return true;
				}
			}

			string session = "";
			NNTPClient client = new NNTPClient();
			session = client.NewsConnect(server, 119);
			if(session == "not connected") return false;
			else
			{
				client.sendMessage("list newsgroups");
				string groups = client.getMultiMessage();
				session += client.NewsDisconnect();

				groups = groups.Substring(0, groups.Length - ".\r\n".Length);

				ServerNode rnode = new ServerNode(server);

				if(!existed)
				{
					ServerNode r2node = new ServerNode(server);
					readingGroupTreeView.Nodes.Add(r2node);
				}

				Regex r = new Regex("(?<group>[^\r]+)\r\n");
				Match m = r.Match(groups);

				while(m.Success)
				{
					string g = m.Groups["group"].Value.ToString();
					NewsGroupNode node = new NewsGroupNode(g);
					rnode.Nodes.Add(node);
					m = m.NextMatch();
				}
				groupsTreeView.Nodes.Add(rnode);
				return true;
			}
		}
		public ServerNode[] GetServerNodes()
		{
			string apath = Application.StartupPath;
			DirectoryInfo di = new DirectoryInfo(apath);
			DirectoryInfo[] dis = di.GetDirectories();

			if(dis.Length > 0)
			{
				ServerNode[] snodes = new ServerNode[dis.Length];
				int sindex = 0;
				foreach(DirectoryInfo da in dis)
				{
					string name = da.Name;
					this.OpenGroups(name, true);
					snodes[sindex] = new ServerNode(name);
					snodes[sindex].NodeFont = new Font("MS UI Gothic", 9);
					DirectoryInfo[] das = da.GetDirectories();
 
					if(das.Length > 0)
					{
						NewsGroupNode[] gnodes = new NewsGroupNode[das.Length];
						int gindex = 0;
						foreach(DirectoryInfo db in das)
						{
							string gname = db.Name;
							gnodes[gindex] = new NewsGroupNode(gname);
							gnodes[gindex].NodeFont = new Font("MS UI Gothic", 9);
							gindex++;
						}
						snodes[sindex].Nodes.AddRange(gnodes);
					}
					sindex++;	
				}
				return snodes;
			}
			return null;
		}

		public ServerNode[] ReturnNodes
		{
			get
			{
				return returnNodes;
			}
		}
	}
}
