/*
NewsArticle.cs : The class of the news article. That has fields of
 the NewsHeader class and the NewsBody class.
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Globalization;

namespace CSamura.NNTP
{
	/// <summary>
	/// j[XL̃NX
	/// </summary>
	[Serializable()]
	public class NewsArticle
	{
		/// <summary>
		/// j[XL̃wb_
		/// </summary>
		private NewsHeader Header;

		/// <summary>
		/// j[XL̃{fB
		/// </summary>
		private NewsBody Body;
		
		/// <summary>
		/// NewsArticle ̃ftHgRXgN^
		/// </summary>
		public NewsArticle()
		{
			Header = new NewsHeader();
			Body = new NewsBody();
		}

		/// <summary>
		/// NewsArticle ̃RXgN^B
		/// Mwb_ɂƂB
		/// </summary>
		/// <param name="header">Mwb_̕</param>
		public NewsArticle(string header)
		{
			Header = new NewsHeader(header);
		}

		/// <summary>
		/// NewsArticle ̃RXgN^B
		/// Mwb_Ɩ{ɂƂB
		/// </summary>
		/// <param name="h">Mwb_̕</param>
		/// <param name="b">M{̕</param>
		public NewsArticle(string h, string b)
		{
			Header = new NewsHeader(h);

			// Content-Type wb_̒l擾
			string ct = Header.GetHeaderValue("Content-Type");

			Body = new NewsBody(b, ct);
		}

		/// <summary>
		/// NewsArticle ̃RXgN^B
		/// Mp̃j[XL쐬B
		/// </summary>
		/// <param name="name">M҂̖O</param>
		/// <param name="address">M҂̃[AhX</param>
		/// <param name="group">ej[XO[v</param>
		/// <param name="subject">j[XL̃^Cg</param>
		/// <param name="body">j[XL̖{</param>
		public NewsArticle(string name, string address,
			string group, string subject, string body)
		{
			Header = new NewsHeader(name, address, group, subject);
			Body = new NewsBody(body);
		}

		/// <summary>
		/// L[ɑΉwb_̒lo\bhB
		/// ł NewsHeader NX GetHeaderValue \bhĂяoĂB
		/// </summary>
		/// <param name="key">wb_̃L[̒l</param>
		/// <returns>Ήwb_̒l</returns>
		public string GetHeaderValue(string key)
		{
			return Header.GetHeaderValue(key);
		}

		/// <summary>
		/// j[XL̃wb_̃L[ƒlׂĎo\bhB
		/// ł NewsHeader NX GetHeaders \bhĂяoĂB
		/// </summary>
		/// <returns>j[XLׂ̂Ẵwb_</returns>
		public string GetHeaders()
		{
			return Header.GetHeaders();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public bool SetHeader(string key, string val)
		{
			if(Header.ContainsKey(key))
			{
				return false;
			}
			else
			{
				Header.SetHeader(key,val);
				return true;
			}
		}
		
		/// <summary>
		/// j[XL̃{fB̕Ԃ\bh
		/// </summary>
		/// <returns>{fB̕</returns>
		public string GetDecodedBody()
		{
			return Body.GetDecodedBody();
		}

		/// <summary>
		/// j[XL̓t擾
		/// </summary>
		/// <returns>Header tB[h Date tB[h̒l𕶎ŕԂ</returns>
		public string GetDate()
		{
			return Header.GetDate();
		}
		
		/// <summary>
		/// Mp̃j[XL쐬B
		/// </summary>
		/// <returns>쐬j[XL𕶎ƂĕԂ</returns>
		public string BeforePost()
		{
			string post = "";
			post += Header.GetHeaders();
			post += "\r\n";
			post += Body.GetEncodedBody();
			post += "\r\n.\r\n";

			return post;
		}
	
		/// <summary>
		/// j[XL̃^Cg擾
		/// </summary>
		/// <returns>j[XL̃^Cg̕</returns>
		public string GetSubject()
		{
			return Header.ArticleSubject;
		}

		public string GetFrom()
		{
			return Header.ArticleFrom;
		}

		public void SetBody(string body)
		{
			// Content-Type wb_̒l擾
			string ct = Header.GetHeaderValue("Content-Type");

			Body = new NewsBody(body, ct);
		}

		public bool IsBody()
		{
			string buf;
			try
			{
				buf = "";
				buf += Body.GetDecodedBody();
			}
			catch(NullReferenceException)
			{
				return false;
			}
			buf = null;
			return true;
		}

		public bool ContainsKey(string key)
		{
			return Header.ContainsKey(key);
		}
	}
}