/*
	Skelton for retropc emulator

	Origin : MAME i286 core
	Author : Takeda.Toshiya
	Date   : 2012.10.18-

	[ 8086/8088/80186/V30 ]
*/

#ifndef _I86_H_
#define _I86_H_

#include "device.h"

#define SIG_I86_TEST	0

//#ifdef USE_DEBUGGER
class DEBUGGER;
//#endif

enum {
	INTEL_80286 = 0,
	NEC_V30,
	INTEL_8086,
	INTEL_80186,
	INTEL_8088,
};

class  DLL_PREFIX I86 : public DEVICE
{
private:
	bool _SINGLE_MODE_DMA;
	bool _USE_DEBUGGER;
	DEVICE *d_mem, *d_io, *d_pic;
//#ifdef I86_PSEUDO_BIOS
	DEVICE *d_bios;
//#endif
//#ifdef SINGLE_MODE_DMA
	DEVICE *d_dma;
//#endif
//#ifdef USE_DEBUGGER
	DEBUGGER *d_debugger;
//#endif
	void *opaque;
	
public:
	I86(VM_TEMPLATE* parent_vm, EMU_TEMPLATE* parent_emu) : DEVICE(parent_vm, parent_emu)
	{
//#ifdef I86_PSEUDO_BIOS
		d_bios = NULL;
//#endif
//#ifdef SINGLE_MODE_DMA
		d_dma = NULL;
//#endif
		device_model = INTEL_8086;
	}
	~I86() {}
	
	// common functions
	void initialize();
	void release();
	void reset();
	int __FASTCALL run(int icount);
	void __FASTCALL write_signal(int id, uint32_t data, uint32_t mask);
	void __FASTCALL set_intr_line(bool line, bool pending, uint32_t bit);
	void __FASTCALL set_extra_clock(int icount);
	int get_extra_clock();
	uint32_t get_pc();
	uint32_t get_next_pc();
//#ifdef USE_DEBUGGER
	bool is_cpu()
	{
		return true;
	}
	bool is_debugger_available()
	{
		return true;
	}
	void *get_debugger()
	{
		return d_debugger;
	}
	uint32_t get_debug_prog_addr_mask()
	{
		return 0xfffff;
	}
	uint32_t get_debug_data_addr_mask()
	{
		return 0xfffff;
	}
	void __FASTCALL write_debug_data8(uint32_t addr, uint32_t data);
	uint32_t __FASTCALL read_debug_data8(uint32_t addr);
	void __FASTCALL write_debug_data16(uint32_t addr, uint32_t data);
	uint32_t __FASTCALL read_debug_data16(uint32_t addr);
	void __FASTCALL write_debug_io8(uint32_t addr, uint32_t data);
	uint32_t __FASTCALL read_debug_io8(uint32_t addr);
	void __FASTCALL write_debug_io16(uint32_t addr, uint32_t data);
	uint32_t __FASTCALL read_debug_io16(uint32_t addr);
	bool write_debug_reg(const _TCHAR *reg, uint32_t data);
	uint32_t __FASTCALL read_debug_reg(const _TCHAR *reg);
	bool get_debug_regs_info(_TCHAR *buffer, size_t buffer_len);
	int debug_dasm(uint32_t pc, _TCHAR *buffer, size_t buffer_len);
//#endif
	bool process_state(FILEIO* state_fio, bool loading);
	
	// unique function
	void set_context_mem(DEVICE* device)
	{
		d_mem = device;
	}
	void set_context_io(DEVICE* device)
	{
		d_io = device;
	}
	void set_context_intr(DEVICE* device, uint32_t bit = 0xffffffff)
	{
		d_pic = device;
	}
//#ifdef I86_PSEUDO_BIOS
	void set_context_bios(DEVICE* device)
	{
		d_bios = device;
	}
//#endif
//#ifdef SINGLE_MODE_DMA
	void set_context_dma(DEVICE* device)
	{
		d_dma = device;
	}
//#endif
//#ifdef USE_DEBUGGER
	void set_context_debugger(DEBUGGER* device)
	{
		d_debugger = device;
	}
//#endif
	int device_model;
};

#endif
