/*
 * Decompiled with CFR 0.152.
 */
package egeyama.jsf.validator;

import egeyama.jsf.util.FacesUtils;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class DoubleByteValidator
implements Validator {
    public static final String MESSAGE_ID = "egeyama.jsf.NOT_DOUBLE_BYTE_VALUE";

    public void validate(FacesContext context, UIComponent uiComponent, Object value) {
        if (context == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        String inputValue = (String)value;
        byte[] bytes = null;
        try {
            bytes = inputValue.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException e) {
            throw new ValidatorException(new FacesMessage(e.getMessage()), (Throwable)e);
        }
        if (inputValue.length() * 2 != bytes.length) {
            UIInput input = (UIInput)uiComponent;
            input.setValid(false);
            String targetId = input.getId();
            String label = FacesUtils.findLabel(context, targetId);
            if (label == null) {
                label = targetId;
            }
            ResourceBundle bundle = ResourceBundle.getBundle("egeyama.jsf.validator.Messages");
            String message = MessageFormat.format(bundle.getString(MESSAGE_ID), label);
            throw new ValidatorException(new FacesMessage(message, ""));
        }
    }
}

