/*
 * Decompiled with CFR 0.152.
 */
package egeyama.bt.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.types.Path;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class MktldTask
extends Javadoc {
    private static final String DEFAULT_TLIB_VERSION = "1.0";
    private static final String DEFAULT_JSP_VERSION = "1.2";
    private static final String TAGLIB_DOCLET = "egeyama.bt.doclet.TaglibDoclet";
    public static final String NAME_IS_REQUIRE = "name\u5c5e\u6027\u306f\u7701\u7565\u3067\u304d\u307e\u305b\u3093\u3002";
    public static final String DIR_IS_REQUIRED = "dir\u5c5e\u6027\u306f\u7701\u7565\u3067\u304d\u307e\u305b\u3093\u3002";
    private static final String EXTENTION = ".tld";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String SHORT_NAME_IS_REQUIRED = "shortName\u5c5e\u6027\u306f\u7701\u7565\u3067\u304d\u307e\u305b\u3093\u3002";
    private String name;
    private String dir;
    private Path docletpath;
    private String jspVersion;
    private String tlibVersion;
    private String shortName;
    private String templateDir = "xdocs/templates";
    private File workDir;

    public void setName(String name) {
        this.name = name;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void execute() {
        super.execute();
        if (this.name == null) {
            throw new BuildException(NAME_IS_REQUIRE);
        }
        if (this.dir == null) {
            throw new BuildException(DIR_IS_REQUIRED);
        }
        if (this.jspVersion == null) {
            this.jspVersion = DEFAULT_JSP_VERSION;
        }
        if (this.tlibVersion == null) {
            this.tlibVersion = DEFAULT_TLIB_VERSION;
        }
        if (this.shortName == null) {
            throw new BuildException(SHORT_NAME_IS_REQUIRED);
        }
        File tld = new File(this.dir, String.valueOf(this.name) + EXTENTION);
        Writer out = null;
        BufferedReader in = null;
        try {
            try {
                Velocity.init();
                VelocityContext context = new VelocityContext();
                File[] xmlList = this.workDir.listFiles();
                ArrayList<String> tagList = new ArrayList<String>();
                int i = 0;
                while (i < xmlList.length) {
                    StringBuffer sb = new StringBuffer();
                    File file = xmlList[i];
                    if (!file.isDirectory()) {
                        in = new BufferedReader(new FileReader(file));
                        while (in.ready()) {
                            sb.append(in.readLine()).append(LINE_SEPARATOR);
                        }
                        tagList.add(sb.toString());
                        in.close();
                    }
                    ++i;
                }
                context.put("tlibVersion", (Object)this.tlibVersion);
                context.put("jspVersion", (Object)this.jspVersion);
                context.put("shortName", (Object)this.shortName);
                context.put("tagList", tagList);
                Template template = Velocity.getTemplate((String)(String.valueOf(this.templateDir) + "/web-jsptaglibrary_1_2.vm"));
                out = new BufferedWriter(new FileWriter(tld));
                template.merge((Context)context, out);
                out.flush();
                this.log(String.valueOf(tld.toString()) + "\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u3059...", 2);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            catch (ResourceNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
            catch (ParseErrorException e) {
                throw new BuildException((Throwable)e);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    public void maybeConfigure() {
        super.maybeConfigure();
        String sWorkDir = "/work";
        this.workDir = new File(String.valueOf(this.dir) + sWorkDir);
        if (!this.workDir.exists()) {
            this.workDir.mkdirs();
        }
        Javadoc.DocletInfo doclet = this.createDoclet();
        doclet.setName(TAGLIB_DOCLET);
        doclet.setPath(this.docletpath);
        Javadoc.DocletParam param = doclet.createParam();
        param.setName("-destdir");
        param.setValue(String.valueOf(this.dir) + sWorkDir);
    }

    public void setDocletPath(Path path) {
        this.docletpath = path;
    }

    public void setJspVersion(String jspVersion) {
        this.jspVersion = jspVersion;
    }

    public void setTlibVersion(String tlibVersion) {
        this.tlibVersion = tlibVersion;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }
}

