/*
 * Decompiled with CFR 0.152.
 */
package egeyama.commons.util;

import egeyama.commons.util.NullSafeUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessHelper {
    private Process process;
    private List<String> errorList;
    private List<String> outList;

    public ProcessHelper(Process process) {
        this.process = process;
    }

    public List<String> getOut() throws IOException {
        if (this.errorList == null) {
            this.getError();
        }
        if (this.outList != null) {
            return this.outList;
        }
        BufferedReader bufferedReader = null;
        this.outList = new ArrayList<String>();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                this.outList.add(string);
            }
        }
        catch (IOException iOException) {
            try {
                throw iOException;
            }
            catch (Throwable throwable) {
                NullSafeUtils.close(bufferedReader);
                throw throwable;
            }
        }
        NullSafeUtils.close(bufferedReader);
        return this.outList;
    }

    public List<String> getError() throws IOException {
        if (this.errorList != null) {
            return this.errorList;
        }
        BufferedReader bufferedReader = null;
        this.errorList = new ArrayList<String>();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                this.errorList.add(string);
            }
        }
        catch (IOException iOException) {
            try {
                throw iOException;
            }
            catch (Throwable throwable) {
                NullSafeUtils.close(bufferedReader);
                throw throwable;
            }
        }
        NullSafeUtils.close(bufferedReader);
        return this.errorList;
    }
}

