using System;
using System.Data;
using System.Data.Odbc;
using System.IO;

using NUnit.Framework;

using Uguu.IO.Csv;

namespace Uguu.IO.Csv.Test
{
    [TestFixture]
	public sealed class CsvWriterTest
	{
	    [Test]
	    public void TestWrite1()
	    {
	        string expected = "foo,bar,boo" + Environment.NewLine
	                        + "111,222,333" + Environment.NewLine;
	        
	        StringWriter writer = new StringWriter();
	        using (CsvWriter csvWriter = new CsvWriter(writer))
	        {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write("foo");
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write("bar");
	            Assert.AreEqual(2, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write("boo");
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.Write("111");
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.Write("222");
	            Assert.AreEqual(2, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.Write("333");
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
	        }
	        Assert.AreEqual(expected, writer.ToString());
	        
	        writer = new StringWriter();
	        using (CsvWriter csvWriter = new CsvWriter(writer))
	        {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write(new string[]{"foo", "bar", "boo"});
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.Write(new string[]{"111", "222", "333"});
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
	        }
	        Assert.AreEqual(expected, writer.ToString());
	        
	        writer = new StringWriter();
	        using (CsvWriter csvWriter = new CsvWriter(writer))
	        {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write(new string[][]{
	                                new string[]{"foo", "bar", "boo"},
	                                new string[]{"111", "222", "333"},
	                            });
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
	        }
	        Assert.AreEqual(expected, writer.ToString());
	    }
	    [Test]
	    public void TestWrite2()
	    {
	        string expected = "111" + Environment.NewLine
	                        + "222,222" + Environment.NewLine
	                        + "333,333,333" + Environment.NewLine;
	        
	        StringWriter writer = new StringWriter();
	        using (CsvWriter csvWriter = new CsvWriter(writer))
	        {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write("111");
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.Write("222");
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.Write("222");
	            Assert.AreEqual(2, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
	            
	            csvWriter.Write("333");
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
	            
	            csvWriter.Write("333");
	            Assert.AreEqual(2, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
	            
	            csvWriter.Write("333");
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(3, csvWriter.RowIndex);
	        }
	        Assert.AreEqual(expected, writer.ToString());
	        
	        writer = new StringWriter();
	        using (CsvWriter csvWriter = new CsvWriter(writer))
	        {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write(new string[]{"111"});
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.Write(new string[]{"222", "222"});
	            Assert.AreEqual(2, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
	            
	            csvWriter.Write(new string[]{"333", "333", "333"});
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(3, csvWriter.RowIndex);
	        }
	        Assert.AreEqual(expected, writer.ToString());
	        
	        writer = new StringWriter();
	        using (CsvWriter csvWriter = new CsvWriter(writer))
	        {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write(new string[][]{
	                                new string[]{"111"},
	                                new string[]{"222", "222"},
	                                new string[]{"333", "333", "333"},
	                            });
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(3, csvWriter.RowIndex);
	        }
	        Assert.AreEqual(expected, writer.ToString());
	    }
	    [Test]
	    public void TestWrite3()
	    {
	        string expected = "foo,bar,\"boo" + Environment.NewLine
	                        + "111,222\",333" + Environment.NewLine;
	        
	        StringWriter writer = new StringWriter();
	        using (CsvWriter csvWriter = new CsvWriter(writer))
	        {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write("foo");
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write("bar");
	            Assert.AreEqual(2, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write("boo" + Environment.NewLine + "111,222");
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write("333");
	            Assert.AreEqual(4, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	        }
	        Assert.AreEqual(expected, writer.ToString());
	        
	        writer = new StringWriter();
	        using (CsvWriter csvWriter = new CsvWriter(writer))
	        {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write(new string[]{"foo", "bar", "boo" + Environment.NewLine + "111,222", "333"});
	            Assert.AreEqual(4, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	        }
	        Assert.AreEqual(expected, writer.ToString());
	        
	        writer = new StringWriter();
	        using (CsvWriter csvWriter = new CsvWriter(writer))
	        {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
	            
	            csvWriter.Write(new string[][]{
	                                new string[]{"foo", "bar", "boo" + Environment.NewLine + "111,222", "333"}
	                            });
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
	        }
	        Assert.AreEqual(expected, writer.ToString());
	    }
	    [Test]
	    public void TestWrite4()
	    {
            string expected = "foo,bar,boo" + Environment.NewLine
                            + "" + Environment.NewLine
                            + ",,," + Environment.NewLine
                            + "111,222,333" + Environment.NewLine;
            
            StringWriter writer = new StringWriter();
            using (CsvWriter csvWriter = new CsvWriter(writer))
            {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
                
	            csvWriter.Write("foo");
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
                
	            csvWriter.Write("bar");
	            Assert.AreEqual(2, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
                
	            csvWriter.Write("boo");
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
                
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
                
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
                
	            csvWriter.Write((string) null);
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
                
	            csvWriter.Write((string) null);
	            Assert.AreEqual(2, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
                
	            csvWriter.Write((string) null);
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
                
	            csvWriter.Write((string) null);
	            Assert.AreEqual(4, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
                
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(3, csvWriter.RowIndex);
                
	            csvWriter.Write("111");
	            Assert.AreEqual(1, csvWriter.ColumnIndex);
	            Assert.AreEqual(3, csvWriter.RowIndex);
                
	            csvWriter.Write("222");
	            Assert.AreEqual(2, csvWriter.ColumnIndex);
	            Assert.AreEqual(3, csvWriter.RowIndex);
                
	            csvWriter.Write("333");
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(3, csvWriter.RowIndex);
                
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(4, csvWriter.RowIndex);
            }
            Assert.AreEqual(expected, writer.ToString());
            
            writer = new StringWriter();
            using (CsvWriter csvWriter = new CsvWriter(writer))
            {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
                
	            csvWriter.Write(new string[]{"foo", "bar", "boo"});
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
                
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(1, csvWriter.RowIndex);
                
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
                
	            csvWriter.Write(new string[]{null, null, null, null});
	            Assert.AreEqual(4, csvWriter.ColumnIndex);
	            Assert.AreEqual(2, csvWriter.RowIndex);
                
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(3, csvWriter.RowIndex);
                
	            csvWriter.Write(new string[]{"111", "222", "333"});
	            Assert.AreEqual(3, csvWriter.ColumnIndex);
	            Assert.AreEqual(3, csvWriter.RowIndex);
                
	            csvWriter.WriteNewLine();
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(4, csvWriter.RowIndex);
            }
            Assert.AreEqual(expected, writer.ToString());
            
            writer = new StringWriter();
            using (CsvWriter csvWriter = new CsvWriter(writer))
            {
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(0, csvWriter.RowIndex);
                
	            csvWriter.Write(new string[][]{
                                    new string[]{"foo", "bar", "boo"},
                                    new string[]{},
                                    new string[]{null, null, null, null},
                                    new string[]{"111", "222", "333"},
                                });
	            Assert.AreEqual(0, csvWriter.ColumnIndex);
	            Assert.AreEqual(4, csvWriter.RowIndex);
            }
            Assert.AreEqual(expected, writer.ToString());
	    }
	    [Test]
	    public void TestWriteDataReader1()
	    {
			string expected = "1000000,東京都,千代田区,以下に掲載がない場合" + Environment.NewLine
			                + "1000001,東京都,千代田区,千代田" + Environment.NewLine
			                + "1000002,東京都,千代田区,皇居外苑" + Environment.NewLine
			                + "1000003,東京都,千代田区,一ツ橋（１丁目）" + Environment.NewLine
			                + "1000004,東京都,千代田区,大手町" + Environment.NewLine
			                + "1000005,東京都,千代田区,丸の内（次のビルを除く）" + Environment.NewLine
			                + "1000006,東京都,千代田区,有楽町" + Environment.NewLine
			                + "1000011,東京都,千代田区,内幸町" + Environment.NewLine
			                + "1000012,東京都,千代田区,日比谷公園" + Environment.NewLine
			                + "1000013,東京都,千代田区,霞が関（次のビルを除く）" + Environment.NewLine
			                + "1000014,東京都,千代田区,永田町（次のビルを除く）" + Environment.NewLine
			                + "1000100,東京都,大島大島町,以下に掲載がない場合" + Environment.NewLine
			                + "1000101,東京都,大島大島町,元町" + Environment.NewLine
			                + "1000102,東京都,大島大島町,岡田" + Environment.NewLine
			                + "1000103,東京都,大島大島町,泉津" + Environment.NewLine
			                + "1000104,東京都,大島大島町,野増" + Environment.NewLine
			                + "1000211,東京都,大島大島町,差木地" + Environment.NewLine
			                + "1000212,東京都,大島大島町,波浮港" + Environment.NewLine
			                + "1000301,東京都,利島利島村,利島村一円" + Environment.NewLine
			                + "1000400,東京都,新島新島村,以下に掲載がない場合" + Environment.NewLine
			                + "1000401,東京都,新島新島村,若郷" + Environment.NewLine
			                + "1000402,東京都,新島新島村,本村" + Environment.NewLine
			                + "1000511,東京都,新島新島村,式根島" + Environment.NewLine
			                + "1000601,東京都,神津島神津島村,神津島村一円" + Environment.NewLine
			                + "1001100,東京都,三宅島三宅村,以下に掲載がない場合" + Environment.NewLine
			                + "1001101,東京都,三宅島三宅村,神着" + Environment.NewLine
			                + "1001102,東京都,三宅島三宅村,伊豆" + Environment.NewLine
			                + "1001103,東京都,三宅島三宅村,伊ケ谷" + Environment.NewLine
			                + "1001211,東京都,三宅島三宅村,坪田" + Environment.NewLine
			                + "1001212,東京都,三宅島三宅村,阿古" + Environment.NewLine
			                + "1001213,東京都,三宅島三宅村,雄山" + Environment.NewLine
			                + "1001301,東京都,御蔵島御蔵島村,御蔵島村一円" + Environment.NewLine
			                + "1001400,東京都,八丈島八丈町,以下に掲載がない場合" + Environment.NewLine
			                + "1001401,東京都,八丈島八丈町,大賀郷" + Environment.NewLine
			                + "1001511,東京都,八丈島八丈町,三根" + Environment.NewLine
			                + "1001621,東京都,八丈島八丈町,樫立" + Environment.NewLine
			                + "1001622,東京都,八丈島八丈町,末吉" + Environment.NewLine
			                + "1001623,東京都,八丈島八丈町,中之郷" + Environment.NewLine
			                + "1001701,東京都,青ケ島青ケ島村,青ケ島村一円" + Environment.NewLine
			                + "1002100,東京都,小笠原諸島小笠原村,以下に掲載がない場合" + Environment.NewLine
			                + "1002101,東京都,小笠原諸島小笠原村,父島" + Environment.NewLine
			                + "1002211,東京都,小笠原諸島小笠原村,母島" + Environment.NewLine;
	        
			StringWriter writer = new StringWriter();
	        
			OdbcConnection conn = new OdbcConnection("DSN=csv-io-net");
			try
			{
			    conn.Open();
			    
	            OdbcCommand command = conn.CreateCommand();
	            command.CommandText = "SELECT ID, PREFECTURE, CITY, OTHER FROM ZIPCODE WHERE ID < 1006000 ORDER BY ID";
	            OdbcDataReader dataReader = command.ExecuteReader();
	            try
	            {
	                using (CsvWriter csvWriter = new CsvWriter(writer))
	                {
        	            Assert.AreEqual(0, csvWriter.ColumnIndex);
        	            Assert.AreEqual(0, csvWriter.RowIndex);
	                    
        	            csvWriter.Write(dataReader);
        	            Assert.AreEqual(0, csvWriter.ColumnIndex);
        	            Assert.AreEqual(42, csvWriter.RowIndex);
	                }
	            }
	            finally
	            {
	                dataReader.Close();
	            }
			}
			finally
			{
			    conn.Close();
			}
	        
	        Assert.AreEqual(expected, writer.ToString());
	    }
	    [Test]
	    public void TestWriteDataReader2()
	    {
			string expected = "1000000,東京都" + Environment.NewLine
			                + "1000001,東京都" + Environment.NewLine
			                + "1000002,東京都" + Environment.NewLine
			                + "1000003,東京都" + Environment.NewLine
			                + "1000004,東京都" + Environment.NewLine
			                + "1000005,東京都" + Environment.NewLine
			                + "1000006,東京都" + Environment.NewLine
			                + "1000011,東京都" + Environment.NewLine
			                + "1000012,東京都" + Environment.NewLine
			                + "1000013,東京都" + Environment.NewLine;
			
			StringWriter writer = new StringWriter();
			
			OdbcConnection conn = new OdbcConnection("DSN=csv-io-net");
			try
			{
			    conn.Open();
			    
			    OdbcCommand command = conn.CreateCommand();
			    command.CommandText = "SELECT ID, PREFECTURE, CITY, OTHER FROM ZIPCODE ORDER BY ID";
			    OdbcDataReader dataReader = command.ExecuteReader();
			    try
			    {
			        using (CsvWriter csvWriter = new CsvWriter(writer))
			        {
        	            Assert.AreEqual(0, csvWriter.ColumnIndex);
        	            Assert.AreEqual(0, csvWriter.RowIndex);
			            
        	            csvWriter.Write(dataReader, new string[]{"id", "prefecture"}, 10);
        	            Assert.AreEqual(0, csvWriter.ColumnIndex);
        	            Assert.AreEqual(10, csvWriter.RowIndex);
			        }
			    }
			    finally
			    {
			        dataReader.Close();
			    }
			}
			finally
			{
			    conn.Close();
			}
			
			Assert.AreEqual(expected, writer.ToString());
	    }
	    [Test]
	    public void TestIsClosed()
	    {
	        StringWriter writer = new StringWriter();
	        CsvWriter csvWriter = new CsvWriter(writer);
	        try
	        {
	            Assert.IsFalse(csvWriter.IsClosed);
	            
	            csvWriter.Write("foo");
	            Assert.IsFalse(csvWriter.IsClosed);
	            
	            csvWriter.Write("bar");
	            Assert.IsFalse(csvWriter.IsClosed);
	            
	            csvWriter.Write("boo");
	            Assert.IsFalse(csvWriter.IsClosed);
	        }
	        finally
	        {
	            csvWriter.Close();
	        }
            Assert.IsTrue(csvWriter.IsClosed);
	    }
	    [Test]
	    public void TestClose()
	    {
	        StringWriter writer = new StringWriter();
	        CsvWriter csvWriter = new CsvWriter(writer);
	        csvWriter.Write("foo");
	        csvWriter.Write("bar");
	        csvWriter.Write("boo");
	        csvWriter.Close();
	        
	        Assert.AreEqual(3, csvWriter.ColumnIndex);
	        Assert.AreEqual(0, csvWriter.RowIndex);
	        try
	        {
	            csvWriter.Write("111");
	            Assert.Fail();
	        }
	        catch (ObjectDisposedException)
	        {
	        }
	    }
	}
}
