/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.csvparser;

import java.io.IOException;
import java.io.Reader;
import jp.sourceforge.csvparser.CSVHandler;
import jp.sourceforge.csvparser.CSVParser;

public class CSVParserImpl
implements CSVParser {
    private static final int END = 0;
    private static final int NEW_RECORD = 1;
    private static final int DELIMITED = 2;
    private static final int VALUE = 3;
    private static final int QUOTED = 4;
    private static final int ESCAPED = 5;
    private char delimiter = (char)44;

    public void parse(Reader reader, CSVHandler handler) throws IOException {
        handler.startDocument();
        int state = 1;
        int ch = 0;
        while ((ch = reader.read()) != -1) {
            state = this.handle(state, ch, handler);
        }
        state = this.handle(state, ch, handler);
        handler.endDocument();
    }

    private int handle(int state, int ch, CSVHandler handler) {
        if (state == 1) {
            return this.handleOnNewRecord(ch, handler);
        }
        if (state == 3) {
            return this.handleOnValue(ch, handler);
        }
        if (state == 2) {
            return this.handleOnDelimited(ch, handler);
        }
        if (state == 4) {
            return this.handleOnQuoted(ch, handler);
        }
        if (state == 5) {
            return this.handleOnEscaped(ch, handler);
        }
        return state;
    }

    private int handleOnNewRecord(int ch, CSVHandler handler) {
        int state = 1;
        if (ch == this.delimiter) {
            handler.startRecord();
            handler.startValue();
            handler.endValue();
            state = 2;
        } else if (ch == 34) {
            handler.startRecord();
            handler.startValue();
            state = 4;
        } else if (ch != 13) {
            if (ch == 10) {
                handler.startRecord();
                handler.endRecord();
            } else if (ch == -1) {
                state = 0;
            } else {
                handler.startRecord();
                handler.startValue();
                handler.character((char)ch);
                state = 3;
            }
        }
        return state;
    }

    private int handleOnValue(int ch, CSVHandler handler) {
        int state = 3;
        if (ch == this.delimiter) {
            handler.endValue();
            state = 2;
        } else if (ch == 34) {
            handler.character((char)ch);
        } else if (ch != 13) {
            if (ch == 10) {
                handler.endValue();
                handler.endRecord();
                state = 1;
            } else if (ch == -1) {
                handler.endValue();
                handler.endRecord();
                state = 0;
            } else {
                handler.character((char)ch);
            }
        }
        return state;
    }

    private int handleOnDelimited(int ch, CSVHandler handler) {
        int state = 2;
        if (ch == this.delimiter) {
            handler.startValue();
            handler.endValue();
        } else if (ch == 34) {
            handler.startValue();
            state = 4;
        } else if (ch != 13) {
            if (ch == 10) {
                handler.startValue();
                handler.endValue();
                handler.endRecord();
                state = 1;
            } else if (ch == -1) {
                handler.startValue();
                handler.endValue();
                handler.endRecord();
                state = 0;
            } else {
                handler.startValue();
                handler.character((char)ch);
                state = 3;
            }
        }
        return state;
    }

    private int handleOnQuoted(int ch, CSVHandler handler) {
        int state = 4;
        if (ch == this.delimiter) {
            handler.character((char)ch);
        } else if (ch == 34) {
            state = 5;
        } else if (ch == 13) {
            handler.character((char)ch);
        } else if (ch == 10) {
            handler.character((char)ch);
        } else if (ch == -1) {
            handler.endValue();
            handler.endRecord();
            state = 0;
        } else {
            handler.character((char)ch);
        }
        return state;
    }

    private int handleOnEscaped(int ch, CSVHandler handler) {
        int state = 5;
        if (ch == this.delimiter) {
            handler.endValue();
            state = 2;
        } else if (ch == 34) {
            handler.character((char)ch);
            state = 4;
        } else if (ch != 13) {
            if (ch == 10) {
                handler.endValue();
                handler.endRecord();
                state = 1;
            } else if (ch == -1) {
                handler.endValue();
                handler.endRecord();
                state = 0;
            } else {
                handler.character((char)ch);
                state = 3;
            }
        }
        return state;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }
}

