package jp.sourceforge.csvparser;

import java.io.IOException;
import java.io.Reader;

public class BasicCSVParser implements CSVParser {

    private static final int END = 0;

    private static final int NEW_RECORD = 1;

    private static final int DELIMITED = 2;

    private static final int VALUE = 3;

    private static final int QUOTED = 4;

    private static final int ESCAPED = 5;

    private char delimiter;

    public BasicCSVParser() {

        this(',');
    }

    public BasicCSVParser(char delimiter) {

        super();
        this.delimiter = delimiter;
    }

    public void parse(Reader reader, CSVHandler handler) throws IOException {

        if (handler.startDocument()) return;
        int state = NEW_RECORD;

        for (int ch = reader.read(); ch != -1; ch = reader.read()) {

            if (state == NEW_RECORD) {

                if (ch == delimiter) {
                    if (handler.startRecord()) return;
                    if (handler.startValue()) return;
                    if (handler.endValue()) return;
                    state = DELIMITED;

                } else if (ch == '"') {
                    if (handler.startRecord()) return;
                    if (handler.startValue()) return;
                    state = QUOTED;

                } else if (ch == '\r') {
                    /* ignore */

                } else if (ch == '\n') {
                    if (handler.startRecord()) return;
                    if (handler.endRecord()) return;

                } else if (ch == -1) {
                    state = END;

                } else {
                    if (handler.startRecord()) return;
                    if (handler.startValue()) return;
                    if (handler.character((char) ch)) return;
                    state = VALUE;
                }

            } else if (state == VALUE) {

                if (ch == delimiter) {
                    if (handler.endValue()) return;
                    state = DELIMITED;

                } else if (ch == '"') {
                    if (handler.character((char) ch)) return;

                } else if (ch == '\r') {
                    /* ignore */

                } else if (ch == '\n') {
                    if (handler.endValue()) return;
                    if (handler.endRecord()) return;
                    state = NEW_RECORD;

                } else if (ch == -1) {
                    if (handler.endValue()) return;
                    if (handler.endRecord()) return;
                    state = END;

                } else {
                    if (handler.character((char) ch)) return;
                }

            } else if (state == DELIMITED) {

                if (ch == delimiter) {
                    if (handler.startValue()) return;
                    if (handler.endValue()) return;

                } else if (ch == '"') {
                    if (handler.startValue()) return;
                    state = QUOTED;

                } else if (ch == '\r') {
                    /* ignore */

                } else if (ch == '\n') {
                    if (handler.startValue()) return;
                    if (handler.endValue()) return;
                    if (handler.endRecord()) return;
                    state = NEW_RECORD;

                } else if (ch == -1) {
                    if (handler.startValue()) return;
                    if (handler.endValue()) return;
                    if (handler.endRecord()) return;
                    state = END;

                } else {
                    if (handler.startValue()) return;
                    if (handler.character((char) ch)) return;
                    state = VALUE;
                }

            } else if (state == QUOTED) {

                if (ch == delimiter) {
                    if (handler.character((char) ch)) return;

                } else if (ch == '"') {
                    state = ESCAPED;

                } else if (ch == '\r') {
                    if (handler.character((char) ch)) return;

                } else if (ch == '\n') {
                    if (handler.character((char) ch)) return;

                } else if (ch == -1) {
                    if (handler.endValue()) return;
                    if (handler.endRecord()) return;
                    state = END;

                } else {
                    if (handler.character((char) ch)) return;
                }

            } else if (state == ESCAPED) {

                if (ch == delimiter) {
                    if (handler.endValue()) return;
                    state = DELIMITED;

                } else if (ch == '"') {
                    if (handler.character((char) ch)) return;
                    state = QUOTED;

                } else if (ch == '\r') {
                    /* ignore */

                } else if (ch == '\n') {
                    if (handler.endValue()) return;
                    if (handler.endRecord()) return;
                    state = NEW_RECORD;

                } else if (ch == -1) {
                    if (handler.endValue()) return;
                    if (handler.endRecord()) return;
                    state = END;

                } else {
                    if (handler.character((char) ch)) return;
                    state = VALUE;
                }

            } else {
                /* ignore */
            }
        }

        if (state == NEW_RECORD) {
            state = END;

        } else if (state == VALUE) {
            if (handler.endValue()) return;
            if (handler.endRecord()) return;
            state = END;

        } else if (state == DELIMITED) {
            if (handler.startValue()) return;
            if (handler.endValue()) return;
            if (handler.endRecord()) return;
            state = END;

        } else if (state == QUOTED) {
            if (handler.endValue()) return;
            if (handler.endRecord()) return;
            state = END;

        } else if (state == ESCAPED) {
            if (handler.endValue()) return;
            if (handler.endRecord()) return;
            state = END;

        } else {
            /* ignore */
        }

        if (handler.endDocument()) return;
    }

    public char getDelimiter() {

        return delimiter;
    }

    public void setDelimiter(char delimiter) {

        this.delimiter = delimiter;
    }
}