package jp.sourceforge.csvparser;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

public class BasicCSVReaderTest extends TestCase {

    public BasicCSVReaderTest(String name) {

        super(name);
    }

    public void testReadRecord() throws Exception {

        List recordList = new ArrayList();
        CSVParser parser = new BasicCSVParser();
        String csv = "1,One,First\r\n2,Two,Second\r\n3,Three,Third\r\n";
        BasicCSVReader reader = new BasicCSVReader(CSVTestUtils.openReader(csv), parser);

        try {
            String[] record = null;

            while ((record = reader.readRecord()) != null) {
                recordList.add(record);
            }

        } finally {
            reader.close();
        }

        String[][] records = (String[][]) recordList.toArray(new String[recordList.size()][]);
        String[][] expected = {
                {
                        "1", "One", "First"
                }, {
                        "2", "Two", "Second"
                }, {
                        "3", "Three", "Third"
                },
        };
        CSVTestUtils.assertEquals(expected, records);
    }
}