package jp.sourceforge.csvparser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

public class BasicCSVUtilityTest extends TestCase {

    private BasicCSVUtility utility;

    public BasicCSVUtilityTest(String name) {

        super(name);
    }

    protected void setUp() throws Exception {

        super.setUp();
        utility = new BasicCSVUtility();
    }

    public void testParse() throws Exception {

        String[][] records = null;
        Reader reader = CSVTestUtils.openReader("1,One,First\r\n2,Two,Second\r\n3,Three,Third\r\n");

        try {
            records = utility.parse(reader);

        } finally {
            reader.close();
        }

        String[][] expected = {
                { "1", "One", "First" },
                { "2", "Two", "Second" },
                { "3", "Three", "Third" },
        };
        CSVTestUtils.assertEquals(expected, records);
    }

    public void testCreateCSVReader() throws Exception {

        List recordList = new ArrayList();
        CSVParser parser = new BasicCSVParser();
        String csv = "1,One,First\r\n2,Two,Second\r\n3,Three,Third\r\n";
        CSVReader reader = utility.createCSVReader(CSVTestUtils.openReader(csv));
        
        try {
            String[] record = null;

            while ((record = reader.readRecord()) != null) {
                recordList.add(record);
            }

        } finally {
            reader.close();
        }

        String[][] records = (String[][]) recordList.toArray(new String[recordList.size()][]);
        String[][] expected = {
                { "1", "One", "First" },
                { "2", "Two", "Second" },
                { "3", "Three", "Third" },
        };
        CSVTestUtils.assertEquals(expected, records);
    }
}