package jp.sourceforge.csvparser;

import junit.framework.TestCase;

public class BulkCSVHandlerTest extends TestCase {

    private BulkCSVHandler handler;

    public BulkCSVHandlerTest(String name) {

        super(name);
    }

    protected void setUp() throws Exception {

        super.setUp();
        handler = new BulkCSVHandler();
    }

    public void testGetRecordsEmptyDocument() throws Exception {

        handler.startDocument();
        handler.endDocument();
        String[][] actual = handler.getRecords();
        String[][] expected = {};
        CSVTestUtils.assertEquals(expected, actual);
    }

    public void testGetRecordsEmptyRecord() throws Exception {

        handler.startDocument();
        handler.startRecord();
        handler.endRecord();
        handler.endDocument();
        String[][] actual = handler.getRecords();
        String[][] expected = {
            {}
        };
        CSVTestUtils.assertEquals(expected, actual);
    }

    public void testGetRecordsEmptyValue() throws Exception {

        handler.startDocument();
        handler.startRecord();
        handler.startValue();
        handler.endValue();
        handler.endRecord();
        handler.endDocument();
        String[][] actual = handler.getRecords();
        String[][] expected = {
            {
                ""
            }
        };
        CSVTestUtils.assertEquals(expected, actual);
    }
}