package jp.sourceforge.csvparser;

import java.io.IOException;
import java.io.Reader;

public class BasicCSVReader extends CSVReader {

    private CSVParser parser;

    public BasicCSVReader(Reader in, CSVParser parser) {

        super(in);
        this.parser = parser;
    }

    public String[] readRecord() throws IOException {

        SingleRecordCSVHandler handler = createSingleRecordCSVHandler();
        parser.parse(in, handler);
        return handler.getRecord();
    }

    protected SingleRecordCSVHandler createSingleRecordCSVHandler() {

        return new SingleRecordCSVHandler();
    }
}