package jp.sourceforge.csvparser;

import java.io.IOException;
import java.io.Reader;

public class BasicCSVUtility implements CSVUtility {

    private CSVParser parser;

    public BasicCSVUtility() {

        this(new BasicCSVParser());
    }

    public BasicCSVUtility(CSVParser parser) {

        this.parser = parser;
    }

    public String[][] parse(Reader reader) throws IOException {

        BulkCSVHandler handler = createBulkCSVHandler();
        parser.parse(reader, handler);
        return handler.getRecords();
    }

    protected BulkCSVHandler createBulkCSVHandler() {

        return new BulkCSVHandler();
    }

    public CSVReader createCSVReader(Reader reader) {

        return new BasicCSVReader(reader, parser);
    }

    public CSVParser getParser() {

        return parser;
    }

    public void setParser(CSVParser parser) {

        this.parser = parser;
    }
}