package jp.sourceforge.csvparser;

import java.util.ArrayList;
import java.util.List;

public class BulkCSVHandler implements CSVHandler {

    private List recordList;

    private List valueList;

    private StringBuffer valueBuffer;

    public boolean startDocument() {

        recordList = new ArrayList();
        return false;
    }

    public boolean startRecord() {

        valueList = new ArrayList();
        return false;
    }

    public boolean startValue() {

        valueBuffer = new StringBuffer();
        return false;
    }

    public boolean character(char ch) {

        valueBuffer.append(ch);
        return false;
    }

    public boolean endValue() {

        valueList.add(valueBuffer.toString());
        return false;
    }

    public boolean endRecord() {

        recordList.add(valueList.toArray(new String[valueList.size()]));
        return false;
    }

    public boolean endDocument() {

        return false;
    }

    public String[][] getRecords() {

        return (String[][]) recordList.toArray(new String[recordList.size()][]);
    }
}