package jp.sourceforge.csvparser;

import java.util.ArrayList;
import java.util.List;

public class SingleRecordCSVHandler implements CSVHandler {

    private List valueList;

    private StringBuffer valueBuffer;

    public boolean startDocument() {

        return false;
    }

    public boolean startRecord() {

        valueList = new ArrayList();
        return false;
    }

    public boolean startValue() {

        valueBuffer = new StringBuffer();
        return false;
    }

    public boolean character(char ch) {

        valueBuffer.append(ch);
        return false;
    }

    public boolean endValue() {

        valueList.add(valueBuffer.toString());
        return false;
    }

    public boolean endRecord() {

        return true;
    }

    public boolean endDocument() {

        return false;
    }

    public String[] getRecord() {

        if (valueList == null) {
            return null;
        }

        return (String[]) valueList.toArray(new String[valueList.size()]);
    }
}