package jp.sourceforge.csvparser;

import java.util.ArrayList;
import java.util.List;

public class MockCSVHandler implements CSVHandler {

    private List callList;

    public MockCSVHandler() {

        super();
        callList = new ArrayList();
    }

    public String[] getCalls() {

        return (String[]) callList.toArray(new String[callList.size()]);
    }

    public boolean startDocument() {

        callList.add("startDocument");
        return false;
    }

    public boolean startRecord() {

        callList.add("startRecord");
        return false;
    }

    public boolean startValue() {

        callList.add("startValue");
        return false;
    }

    public boolean character(char ch) {

        callList.add("character:" + ch);
        return false;
    }

    public boolean endValue() {

        callList.add("endValue");
        return false;
    }

    public boolean endRecord() {

        callList.add("endRecord");
        return false;
    }

    public boolean endDocument() {

        callList.add("endDocument");
        return false;
    }
}